﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    [Serializable]
    [XmlType(TypeName = "OccupiedBedInfo")]
    [DataContract(Name = "OccupiedBedInfo")]
    [KnownType(typeof(II))]
    public class OccupiedBedInfo
    {
        /// <summary>
        /// Gets or sets the SSN of the patient occupying the bed.
        /// </summary>
        /// <value>
        /// The patient's SSN.
        /// </value>
        [XmlElementAttribute("PatientUID", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "PatientUID", Order = 1)]
        public Guid PatientUID { get; set; }

        /// <summary>
        /// Gets or sets the bed UID.
        /// </summary>
        /// <value>
        /// The bed UID.
        /// </value>
        [XmlElementAttribute("BedUID", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "BedUID", Order = 2)]
        public Guid BedUID { get; set; }

        /// <summary>
        /// Gets or sets the act IEN.
        /// </summary>
        /// <value>
        /// The act IEN.
        /// </value>
        [XmlElementAttribute("ActIEN", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "ActIEN", Order = 3)]
        public string ActIEN { get; set; }

        /// <summary>
        /// Gets or sets the ward UID.
        /// </summary>
        /// <value>
        /// The ward UID.
        /// </value>
        [XmlElementAttribute("WardUID", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "WardUID", Order = 4)]
        public Guid WardUID { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [XmlElementAttribute("EnteredDate", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredDate", Order = 5)]
        public DateTime EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the event date.
        /// </summary>
        /// <value>
        /// The event date.
        /// </value>
        [XmlElementAttribute("EventDate", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "EventDate", Order = 6)]
        public DateTime EventDate { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 7)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsAdmission", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "IsAdmission", Order = 8)]
        public bool IsAdmission { get; set; }
    }
}
