﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Icon detail class.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "IconDetail")]
    [DataContract(Name = "IconDetail")]
    public class IconDetail
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the group.
        /// </summary>
        /// <value>
        /// The group.
        /// </value>
        [XmlElementAttribute("Group", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "Group", Order = 2)]
        public string Group { get; set; }

        /// <summary>
        /// Gets or sets the subgroup.
        /// </summary>
        /// <value>
        /// The subgroup.
        /// </value>
        [XmlElementAttribute("Subgroup", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Subgroup", Order = 3)]
        public string Subgroup { get; set; }

        /// <summary>
        /// Gets or sets the type of the icon.
        /// </summary>
        /// <value>
        /// The type of the icon.
        /// </value>
        [XmlElementAttribute("IconType", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "IconType", Order = 4)]
        public CD IconType { get; set; }

        /// <summary>
        /// Gets or sets the image bytes.
        /// </summary>
        /// <value>
        /// The image bytes.
        /// </value>
        [XmlElementAttribute("ImageBytes", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "ImageBytes", Order = 5)]
        public string ImageBytes { get; set; }

        /// <summary>
        /// Gets or sets the image bytes inactive.
        /// </summary>
        /// <value>
        /// The image bytes inactive.
        /// </value>
        [XmlElementAttribute("ImageBytesInactive", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "ImageBytesInactive", Order = 6)]
        public string ImageBytesInactive { get; set; }

        /// <summary>
        /// Gets or sets the index of the order.
        /// </summary>
        /// <value>
        /// The index of the order.
        /// </value>
        [XmlElementAttribute("OrderIndex", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "OrderIndex", Order = 7)]
        public int OrderIndex { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="IconDetail"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("Active", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "Active", Order = 8)]
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the name of the image.
        /// </summary>
        /// <value>
        /// The name of the image.
        /// </value>
        [XmlElementAttribute("ImageName", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "ImageName", Order = 9)]
        public string ImageName { get; set; }

        /// <summary>
        /// Gets or sets the name of the icon.
        /// </summary>
        /// <value>
        /// The name of the icon.
        /// </value>
        [XmlElementAttribute("IconName", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "IconName", Order = 10)]
        public string IconName { get; set; }

        /// <summary>
        /// Gets or sets the short description.
        /// </summary>
        /// <value>
        /// The short description.
        /// </value>
        [XmlElementAttribute("ShortDescription", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "ShortDescription", Order = 11)]
        public string ShortDescription { get; set; }

        /// <summary>
        /// Gets or sets the long description.
        /// </summary>
        /// <value>
        /// The long description.
        /// </value>
        [XmlElementAttribute("LongDescription", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "LongDescription", Order = 12)]
        public string LongDescription { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [XmlElementAttribute("Comment", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "Comment", Order = 13)]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the mouse over text.
        /// </summary>
        /// <value>
        /// The mouse over text.
        /// </value>
        [XmlElementAttribute("MouseOverText", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "MouseOverText", Order = 14)]
        public string MouseOverText { get; set; }

        /// <summary>
        /// Gets or sets the patient or room bed.
        /// </summary>
        /// <value>
        /// The patient or room bed.
        /// </value>
        [XmlElementAttribute("PatientOrRoomBed", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "PatientOrRoomBed", Order = 15)]
        public char? PatientOrRoomBed { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 16)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the name of the facility icon.
        /// </summary>
        /// <value>
        /// The name of the facility icon.
        /// </value>
        [XmlElementAttribute("FacilityIconName", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityIconName", Order = 17)]
        public string FacilityIconName { get; set; }

        /// <summary>
        /// Gets or sets the facility description.
        /// </summary>
        /// <value>
        /// The facility description.
        /// </value>
        [XmlElementAttribute("FacilityDescription", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityDescription", Order = 18)]
        public string FacilityDescription { get; set; }

        /// <summary>
        /// Gets or sets the facility comment.
        /// </summary>
        /// <value>
        /// The facility comment.
        /// </value>
        [XmlElementAttribute("FacilityComment", Order = 19)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityComment", Order = 19)]
        public string FacilityComment { get; set; }

        /// <summary>
        /// Gets or sets the facility mouse over text.
        /// </summary>
        /// <value>
        /// The facility mouse over text.
        /// </value>
        [XmlElementAttribute("FacilityMouseOverText", Order = 20)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityMouseOverText", Order = 20)]
        public string FacilityMouseOverText { get; set; }

        /// <summary>
        /// Gets or sets the facility patient or room bed.
        /// </summary>
        /// <value>
        /// The facility patient or room bed.
        /// </value>
        [XmlElementAttribute("FacilityPatientOrRoomBed", Order = 21)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityPatientOrRoomBed", Order = 21)]
        public char? FacilityPatientOrRoomBed { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [facility active].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [facility active]; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("FacilityActive", Order = 22)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityActive", Order = 22)]
        public bool FacilityActive { get; set; }

        /// <summary>
        /// Gets or sets the index of the facility order.
        /// </summary>
        /// <value>
        /// The index of the facility order.
        /// </value>
        [XmlElementAttribute("FacilityOrderIndex", Order = 23)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityOrderIndex", Order = 23)]
        public int FacilityOrderIndex { get; set; }

        /// <summary>
        /// Gets or sets the entered by.
        /// </summary>
        /// <value>
        /// The entered by.
        /// </value>
        [XmlElementAttribute("EnteredBy", Order = 24)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredBy", Order = 24)]
        public string EnteredBy { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [XmlElementAttribute("EnteredDate", Order = 25)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredDate", Order = 25)]
        public DateTime? EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        [XmlElementAttribute("LastEditBy", Order = 26)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditBy", Order = 26)]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit date.
        /// </summary>
        /// <value>
        /// The last edit date.
        /// </value>
        [XmlElementAttribute("LastEditDate", Order = 27)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditDate", Order = 27)]
        public DateTime? LastEditDate { get; set; }

        /// <summary>
        /// Gets or sets the icon flag id.
        /// </summary>
        /// <value>
        /// The icon flag id.
        /// </value>
        [XmlElementAttribute("IconFlagId", Order = 28)]
        [DataMember(EmitDefaultValue = false, Name = "IconFlagId", Order = 28)]
        public int IconFlagId { get; set; }

        /// <summary>
        /// Gets or sets the published.
        /// </summary>
        /// <value>
        /// The published.
        /// </value>
        [XmlElementAttribute("Published", Order = 29)]
        [DataMember(EmitDefaultValue = false, Name = "Published", Order = 29)]
        public bool? Published { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is associated.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is associated; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsAssociated", Order = 30)]
        [DataMember(EmitDefaultValue = false, Name = "IsAssociated", Order = 30)]
        public bool IsAssociated { get; set; }
    }
}
