﻿using System;
using InfoWorld.HL7.ITS;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contract for managing EMS Staff persons.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "EmsStaff")]
    [DataContract(Name = "EmsStaff")]    
    [KnownType(typeof(II))]
    public class EmsStaff
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the name of the user.
        /// </summary>
        /// <value>
        /// The name of the user.
        /// </value>
        [XmlElementAttribute("UserName", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "UserName", Order = 2)]
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the pin.
        /// </summary>
        /// <value>
        /// The pin.
        /// </value>
        [XmlElementAttribute("Pin", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Pin", Order = 3)]
        public string Pin { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 4)]
        public II FacilityId { get; set; }
    }
}
