﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace BMS.DataContracts
{    
    /// <summary>
    /// Contains data about application and profiles configurations.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "Configuration")]
    [DataContract(Name = "Configuration")]
    public class Configuration
    {        
        #region Public Members

        /// <summary>
        /// Gets or sets the user name for which the configuration is defined.
        /// </summary>
        /// <value>
        /// The configuration user name.
        /// </value>
        [XmlElementAttribute("UserName", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "UserName", Order = 1)]
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the type of the config(whether the configuration is defined for application or for user).
        /// </summary>
        /// <value>
        /// The type of the configuration.
        /// </value>
        [XmlElementAttribute("ConfigType", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "ConfigType", Order = 2)]
        public ConfigType ConfigType { get; set; }

        /// <summary>
        /// Gets or sets the domain of the configuration.
        /// </summary>
        /// <value>
        /// The domain.
        /// </value>
        [XmlElementAttribute("Domain", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Domain", Order = 3)]
        public string Domain { get; set; }

        /// <summary>
        /// Gets or sets the list containing the configuration values.
        /// </summary>
        /// <value>
        /// The section list.
        /// </value>
        [XmlElementAttribute("SectionList", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "SectionList", Order = 4)]
        public Dictionary<string, List<Element>> SectionList { get; set; }
        
        #endregion
    }

    /// <summary>
    /// Enum for configuration values data types.
    /// </summary>
    public enum BasicType : int
    {
        /// <summary>
        /// Integer.
        /// </summary>
        INT,
        /// <summary>
        /// String.
        /// </summary>
        ST,
        /// <summary>
        /// Boolean.
        /// </summary>
        BL,
        /// <summary>
        /// Real.
        /// </summary>
        REAL,
        /// <summary>
        /// Datetime.
        /// </summary>
        TS,
        /// <summary>
        /// Concept Descriptor.
        /// </summary>
        EVS,
        /// <summary>
        /// Entity Identification.
        /// </summary>
        EIS
    };
    /// <summary>
    /// Enum for configuration types.
    /// </summary>
    public enum ConfigType : int
    {
        /// <summary>
        /// User.
        /// </summary>
        USR,
        /// <summary>
        /// Default user.
        /// </summary>
        DEFUSR,
        /// <summary>
        /// Application.
        /// </summary>
        APP,
        /// <summary>
        /// Default application.
        /// </summary>
        DEFAPP
    }; 
}
