﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about bed switches managed by BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedSwitch")]
    [DataContract(Name = "BedSwitch")]
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    [KnownType(typeof(Event))]
    public class BedSwitch : Event
    {        
        /// <summary>
        /// Gets or sets the bed from where the patient is moved(EIS place reference).
        /// </summary>
        /// <value>
        /// The old bed.
        /// </value>
        [XmlElementAttribute("OldBedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "OldBedId", Order = 1)]
        public II OldBedId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        /// <value>
        /// The admission id.
        /// </value>
        [XmlElementAttribute("AdmissionId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionId", Order = 2)]
        public II AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the admission ien.
        /// </summary>
        /// <value>
        /// The admission ien.
        /// </value>
        [XmlElementAttribute("AdmissionIen", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionIen", Order = 3)]
        public string AdmissionIen { get; set; }
    }
}
