﻿using System;
using System.Collections.Generic;
using System.Text;
using BMS.FaultContracts;
using BMS.MT;

namespace BMS.ServiceImplementation.Utils
{
    public class ExceptionFactory
    {
        public static ConfigValueException CreateConfigValueException(ConfigBO config, string message)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ConfigValueException cvEx = new ConfigValueException();

                cvEx.Message = message;
                cvEx.Section = config.SECTION.Value;
                cvEx.Key = config.CONFIG_KEY.Value;
                cvEx.UserName = config.USER_NAME.Value;

                return cvEx;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
