﻿using BMS.MT;
using System;
using BMS.Utils;
using System.Collections.Generic;
using BMS.DataContracts;
using System.Linq;
using System.ServiceModel;

namespace BMS.Translators
{
    public static class TranslatorWaitingListItem
    {
        public static void CopyTo(this WaitingListItemBO waitingListItemBO, DataContracts.WaitingListItem waitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                waitingListItem.CanceledDate = waitingListItemBO.CANCELED_DATE.Value;
                waitingListItem.CreationDate = waitingListItemBO.CREATION_DATE.Value;
                waitingListItem.Id = TranslatorUtils.BuildIdentifier(waitingListItemBO.DOMAIN_ID, waitingListItemBO.ACT_ID);
                waitingListItem.Parent = TranslatorUtils.BuildParentAct(TranslatorUtils.BuildIdentifier(waitingListItemBO.DOMAIN_ID, waitingListItemBO.PARENT_ACT_ID));
                waitingListItem.PatientId = TranslatorUtils.BuildIdentifier(waitingListItemBO.DOMAIN_ID, waitingListItemBO.PATIENT_UID);
                waitingListItem.FlowId = waitingListItemBO.FLOW_ID.Value;
                waitingListItem.IEN = waitingListItemBO.IEN.Value;
                waitingListItem.Authorization = TranslatorUtils.BuildConcept(waitingListItemBO.AUTHORIZED_FEE_CODE, waitingListItemBO.AUTHORIZED_FEE_CODE_SYSTEM, waitingListItemBO.AUTHORIZED_FEE_CODE_SYSTEM_NAME, waitingListItemBO.AUTHORIZED_FEE_DISPLAY_NAME);
                waitingListItem.CommentFee = waitingListItemBO.FEE_COMMENTS.Value;
                waitingListItem.Contract = TranslatorUtils.BuildConcept(waitingListItemBO.CONTRACT_FEE_CODE, waitingListItemBO.CONTRACT_FEE_CODE_SYSTEM, waitingListItemBO.CONTRACT_FEE_CODE_SYSTEM_NAME, waitingListItemBO.CONTRACT_FEE_DISPLAY_NAME);
                waitingListItem.FeeDisposition = TranslatorUtils.BuildConcept(waitingListItemBO.FEE_DISPOSITION_CODE, waitingListItemBO.FEE_DISPOSITION_CODE_SYSTEM, waitingListItemBO.FEE_DISPOSITION_CODE_SYSTEM_NAME, waitingListItemBO.FEE_DISPOSITION_DISPLAY_NAME);       
                waitingListItem.FacilityId = TranslatorUtils.BuildIdentifier(waitingListItemBO.DOMAIN_ID, waitingListItemBO.FACILITY_UID);      
                waitingListItem.Problem = waitingListItemBO.PROBLEM.Value;
                waitingListItem.ReasonFee = TranslatorUtils.BuildConcept(waitingListItemBO.REASON_USING_FEE_CODE, waitingListItemBO.REASON_USING_FEE_CODE_SYSTEM, waitingListItemBO.REASON_USING_FEE_CODE_SYSTEM_NAME, waitingListItemBO.REASON_USING_FEE_DISPLAY_NAME);
                waitingListItem.RemovedDate = waitingListItemBO.REMOVED_DATE.Value;
                waitingListItem.RequestedDate = waitingListItemBO.REQUESTED_DATE.Value;
                waitingListItem.ServiceReceive = TranslatorUtils.BuildConcept(waitingListItemBO.SERVICE_RECEIVING_FEE_CODE, waitingListItemBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM, waitingListItemBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME, waitingListItemBO.SERVICE_RECEIVING_FEE_DISPLAY_NAME);
                waitingListItem.TypeOfBedWard = waitingListItemBO.TYPE_OF_BED_WARD.Value;
                waitingListItem.WaitingArea = TranslatorUtils.BuildConcept(waitingListItemBO.WAITING_AREA_CODE, waitingListItemBO.WAITING_AREA_CODE_SYSTEM, waitingListItemBO.WAITING_AREA_CODE_SYSTEM_NAME, waitingListItemBO.WAITING_AREA_DISPLAY_NAME);
                waitingListItem.RequestedBedId = TranslatorUtils.BuildIdentifier(waitingListItemBO.DOMAIN_ID, waitingListItemBO.REQUESTED_BED_UID);
                waitingListItem.RequestedBedDate = waitingListItemBO.REQUESTED_BED_DATE.Value;
                waitingListItem.VistaSiteId = TranslatorUtils.BuildIdentifier(waitingListItemBO.DOMAIN_ID, waitingListItemBO.VISTA_SITE_UID);
                waitingListItem.IsInHouse = waitingListItemBO.IS_IN_HOUSE.Value;
                waitingListItem.LastEditBy = waitingListItemBO.LAST_EDIT_BY.Value;
                waitingListItem.Comments = waitingListItemBO.COMMENTS.Value;
                waitingListItem.IsBedInIsolation = waitingListItemBO.IS_BED_IN_ISOLATION.Value;
                waitingListItem.WaitTimeAlertDate = waitingListItemBO.WAIT_TIME_ALERT_DATE.Value;
                waitingListItem.IsCommunityLivingCenter = waitingListItemBO.IS_COMMUNITY_LIVING_CENTER.Value;
                waitingListItem.IsEvacuationPatient = waitingListItemBO.IS_EVACUATION_PATIENT.Value;
                waitingListItem.EvacuationActualDate = waitingListItemBO.EVACUATION_ACTUAL_DATE.Value;
                waitingListItem.EvacuationComments = waitingListItemBO.EVACUATION_COMMENTS.Value;
                waitingListItem.EvacuationDestinationAddress = waitingListItemBO.EVACUATION_DESTINATION_ADDRESS.Value;
                waitingListItem.EvacuationDestinationCityState = waitingListItemBO.EVACUATION_DESTINATION_CITY_STATE.Value;
                waitingListItem.EvacuationDestinationPOCTelephone = waitingListItemBO.EVACUATION_DESTINATION_POC_TELEPHONE.Value;
                waitingListItem.EvacuationDispositionStatus = TranslatorUtils.BuildConcept(waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE, waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM, waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM_NAME, waitingListItemBO.EVACUATION_DISPOSITION_STATUS_DISPLAY_NAME);
                waitingListItem.EvacuationEnrouteMedicalAttendant = waitingListItemBO.EVACUATION_ENROUTE_MEDICAL_ATTENDANT.Value;
                waitingListItem.EvacuationEnrouteNonMedicalAttendant = waitingListItemBO.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT.Value;
                waitingListItem.EvacuationEquipSupplyRequirements = waitingListItemBO.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS.Value;
                waitingListItem.EvacuationExpectedDate = waitingListItemBO.EVACUATION_EXPECTED_DATE.Value;
                waitingListItem.EvacuationOriginatorPOCTelephone = waitingListItemBO.EVACUATION_ORIGINATOR_POC_TELEPHONE.Value;
                waitingListItem.EvacuationReasonForDelay = waitingListItemBO.EVACUATION_REASON_FOR_DELAY.Value;
                waitingListItem.EvacuationTransferEvacuateTo = waitingListItemBO.EVACUATION_TRANSFER_EVACUATE_TO.Value;
                waitingListItem.EvacuationTransportationCareLevel = waitingListItemBO.EVACUATION_TRANSPORTATION_CARE_LEVEL.Value;
                waitingListItem.EvacuationTransportationComments = waitingListItemBO.EVACUATION_TRANSPORTATION_COMMENTS.Value;
                waitingListItem.EvacuationTransportationProvider = TranslatorUtils.BuildConcept(waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE, waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM, waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM_NAME, waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_DISPLAY_NAME);
                waitingListItem.EvacuationTransportationType = TranslatorUtils.BuildConcept(waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE, waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM, waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM_NAME, waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_DISPLAY_NAME);
                waitingListItem.EvacuationEnrouteMedicalAttendantNumber = waitingListItemBO.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER.Value;
                waitingListItem.EvacuationEnrouteNonMedicalAttendantNumber = waitingListItemBO.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.WaitingListItem waitingListItem, WaitingListItemBO waitingListItemBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                waitingListItemBO.CANCELED_DATE.Value = waitingListItem.CanceledDate;
                waitingListItemBO.CREATION_DATE.Value = waitingListItem.CreationDate;
                if (waitingListItem.Id != null)
                {
                    waitingListItemBO.DOMAIN_ID.Value = waitingListItem.Id.root;
                    int? actId = waitingListItem.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        waitingListItemBO.ACT_ID.Value = actId.Value;
                }
                if (waitingListItem.Parent != null && waitingListItem.Parent.Id != null)
                    waitingListItemBO.PARENT_ACT_ID.Value = waitingListItem.Parent.Id.extension.ParseAsInt();
                if (waitingListItem.PatientId != null)                
                    waitingListItemBO.PATIENT_UID.Value = System.Guid.Parse(waitingListItem.PatientId.extension);
                    
                waitingListItemBO.FLOW_ID.Value = waitingListItem.FlowId;
                waitingListItemBO.IEN.Value = waitingListItem.IEN;

                if (waitingListItem.FacilityId != null)
                    waitingListItemBO.FACILITY_UID.Value = Guid.Parse(waitingListItem.FacilityId.extension);
                else
                    waitingListItemBO.FACILITY_UID.Value = null;
                if (waitingListItem.Authorization != null)
                {
                    waitingListItemBO.AUTHORIZED_FEE_CODE.Value = waitingListItem.Authorization.code;
                    waitingListItemBO.AUTHORIZED_FEE_CODE_SYSTEM.Value = waitingListItem.Authorization.codeSystem;
                    waitingListItemBO.AUTHORIZED_FEE_CODE_SYSTEM_NAME.Value = waitingListItem.Authorization.codeSystemName;
                    waitingListItemBO.AUTHORIZED_FEE_DISPLAY_NAME.Value = waitingListItem.Authorization.displayName;
                }
                else
                {
                    waitingListItemBO.AUTHORIZED_FEE_CODE.Value = null;
                    waitingListItemBO.AUTHORIZED_FEE_CODE_SYSTEM.Value = null;
                    waitingListItemBO.AUTHORIZED_FEE_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.AUTHORIZED_FEE_DISPLAY_NAME.Value = null;
                }
                if (waitingListItem.Contract != null)
                {
                    waitingListItemBO.CONTRACT_FEE_CODE.Value = waitingListItem.Contract.code;
                    waitingListItemBO.CONTRACT_FEE_CODE_SYSTEM.Value = waitingListItem.Contract.codeSystem;
                    waitingListItemBO.CONTRACT_FEE_CODE_SYSTEM_NAME.Value = waitingListItem.Contract.codeSystemName;
                    waitingListItemBO.CONTRACT_FEE_DISPLAY_NAME.Value = waitingListItem.Contract.displayName;
                }
                else
                {
                    waitingListItemBO.CONTRACT_FEE_CODE.Value = null;
                    waitingListItemBO.CONTRACT_FEE_CODE_SYSTEM.Value = null;
                    waitingListItemBO.CONTRACT_FEE_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.CONTRACT_FEE_DISPLAY_NAME.Value = null;
                }
                waitingListItemBO.FEE_COMMENTS.Value = waitingListItem.CommentFee;
                if (waitingListItem.FeeDisposition != null)
                {
                    waitingListItemBO.FEE_DISPOSITION_CODE.Value = waitingListItem.FeeDisposition.code;
                    waitingListItemBO.FEE_DISPOSITION_CODE_SYSTEM.Value = waitingListItem.FeeDisposition.codeSystem;
                    waitingListItemBO.FEE_DISPOSITION_CODE_SYSTEM_NAME.Value = waitingListItem.FeeDisposition.codeSystemName;
                    waitingListItemBO.FEE_DISPOSITION_DISPLAY_NAME.Value = waitingListItem.FeeDisposition.displayName;
                }
                else
                {
                    waitingListItemBO.FEE_DISPOSITION_CODE.Value = null;
                    waitingListItemBO.FEE_DISPOSITION_CODE_SYSTEM.Value = null;
                    waitingListItemBO.FEE_DISPOSITION_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.FEE_DISPOSITION_DISPLAY_NAME.Value = null;
                }
                waitingListItemBO.PROBLEM.Value = waitingListItem.Problem;
                if (waitingListItem.ReasonFee != null)
                {
                    waitingListItemBO.REASON_USING_FEE_CODE.Value = waitingListItem.ReasonFee.code;
                    waitingListItemBO.REASON_USING_FEE_CODE_SYSTEM.Value = waitingListItem.ReasonFee.codeSystem;
                    waitingListItemBO.REASON_USING_FEE_CODE_SYSTEM_NAME.Value = waitingListItem.ReasonFee.codeSystemName;
                    waitingListItemBO.REASON_USING_FEE_DISPLAY_NAME.Value = waitingListItem.ReasonFee.displayName;
                }
                else
                {
                    waitingListItemBO.REASON_USING_FEE_CODE.Value = null;
                    waitingListItemBO.REASON_USING_FEE_CODE_SYSTEM.Value = null;
                    waitingListItemBO.REASON_USING_FEE_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.REASON_USING_FEE_DISPLAY_NAME.Value = null;
                }
                waitingListItemBO.REMOVED_DATE.Value = waitingListItem.RemovedDate;
                if (waitingListItem.ServiceReceive != null)
                {
                    waitingListItemBO.SERVICE_RECEIVING_FEE_CODE.Value = waitingListItem.ServiceReceive.code;
                    waitingListItemBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM.Value = waitingListItem.ServiceReceive.codeSystem;
                    waitingListItemBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME.Value = waitingListItem.ServiceReceive.codeSystemName;
                    waitingListItemBO.SERVICE_RECEIVING_FEE_DISPLAY_NAME.Value = waitingListItem.ServiceReceive.displayName;
                }
                else
                {
                    waitingListItemBO.SERVICE_RECEIVING_FEE_CODE.Value = null;
                    waitingListItemBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM.Value = null;
                    waitingListItemBO.SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.SERVICE_RECEIVING_FEE_DISPLAY_NAME.Value = null;
                }
                waitingListItemBO.TYPE_OF_BED_WARD.Value = waitingListItem.TypeOfBedWard;
                if (waitingListItem.WaitingArea != null)
                {
                    waitingListItemBO.WAITING_AREA_CODE.Value = waitingListItem.WaitingArea.code;
                    waitingListItemBO.WAITING_AREA_CODE_SYSTEM.Value = waitingListItem.WaitingArea.codeSystem;
                    waitingListItemBO.WAITING_AREA_CODE_SYSTEM_NAME.Value = waitingListItem.WaitingArea.codeSystemName;
                    waitingListItemBO.WAITING_AREA_DISPLAY_NAME.Value = waitingListItem.WaitingArea.displayName;
                }
                waitingListItemBO.REQUESTED_BED_DATE.Value = waitingListItem.RequestedBedDate;
                if (waitingListItem.RequestedBedId != null)
                    waitingListItemBO.REQUESTED_BED_UID.Value = Guid.Parse(waitingListItem.RequestedBedId.extension);                
                else
                    waitingListItemBO.REQUESTED_BED_UID.Value = null;                
                waitingListItemBO.REQUESTED_DATE.Value = waitingListItem.RequestedDate;
                if (waitingListItem.VistaSiteId != null)
                    waitingListItemBO.VISTA_SITE_UID.Value = Guid.Parse(waitingListItem.VistaSiteId.extension);
                else
                    waitingListItemBO.VISTA_SITE_UID.Value = null;

                waitingListItemBO.IS_IN_HOUSE.Value = waitingListItem.IsInHouse;
                waitingListItemBO.LAST_EDIT_BY.Value = waitingListItem.LastEditBy;
                waitingListItemBO.COMMENTS.Value = waitingListItem.Comments;
                waitingListItemBO.IS_BED_IN_ISOLATION.Value = waitingListItem.IsBedInIsolation;
                waitingListItemBO.WAIT_TIME_ALERT_DATE.Value = waitingListItem.WaitTimeAlertDate;
                waitingListItemBO.IS_COMMUNITY_LIVING_CENTER.Value = waitingListItem.IsCommunityLivingCenter;
                waitingListItemBO.IS_EVACUATION_PATIENT.Value = waitingListItem.IsEvacuationPatient;
                waitingListItemBO.EVACUATION_ACTUAL_DATE.Value = waitingListItem.EvacuationActualDate;
                waitingListItemBO.EVACUATION_COMMENTS.Value = waitingListItem.EvacuationComments;
                waitingListItemBO.EVACUATION_DESTINATION_ADDRESS.Value = waitingListItem.EvacuationDestinationAddress;
                waitingListItemBO.EVACUATION_DESTINATION_CITY_STATE.Value = waitingListItem.EvacuationDestinationCityState;
                waitingListItemBO.EVACUATION_DESTINATION_POC_TELEPHONE.Value = waitingListItem.EvacuationDestinationPOCTelephone;

                if (waitingListItem.EvacuationDispositionStatus != null)
                {
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE.Value = waitingListItem.EvacuationDispositionStatus.code;
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM.Value = waitingListItem.EvacuationDispositionStatus.codeSystem;
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM_NAME.Value = waitingListItem.EvacuationDispositionStatus.codeSystemName;
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_DISPLAY_NAME.Value = waitingListItem.EvacuationDispositionStatus.displayName;
                }
                else
                {
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE.Value = null;
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM.Value = null;
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.EVACUATION_DISPOSITION_STATUS_DISPLAY_NAME.Value = null;
                }
                waitingListItemBO.EVACUATION_ENROUTE_MEDICAL_ATTENDANT.Value = waitingListItem.EvacuationEnrouteMedicalAttendant;
                waitingListItemBO.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT.Value = waitingListItem.EvacuationEnrouteNonMedicalAttendant;
                waitingListItemBO.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS.Value = waitingListItem.EvacuationEquipSupplyRequirements;
                waitingListItemBO.EVACUATION_EXPECTED_DATE.Value = waitingListItem.EvacuationExpectedDate;
                waitingListItemBO.EVACUATION_ORIGINATOR_POC_TELEPHONE.Value = waitingListItem.EvacuationOriginatorPOCTelephone;
                waitingListItemBO.EVACUATION_REASON_FOR_DELAY.Value = waitingListItem.EvacuationReasonForDelay;
                waitingListItemBO.EVACUATION_TRANSFER_EVACUATE_TO.Value = waitingListItem.EvacuationTransferEvacuateTo;
                waitingListItemBO.EVACUATION_TRANSPORTATION_CARE_LEVEL.Value = waitingListItem.EvacuationTransportationCareLevel;
                waitingListItemBO.EVACUATION_TRANSPORTATION_COMMENTS.Value = waitingListItem.EvacuationTransportationComments;

                if (waitingListItem.EvacuationTransportationProvider != null)
                {
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE.Value = waitingListItem.EvacuationTransportationProvider.code;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM.Value = waitingListItem.EvacuationTransportationProvider.codeSystem;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM_NAME.Value = waitingListItem.EvacuationTransportationProvider.codeSystemName;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_DISPLAY_NAME.Value = waitingListItem.EvacuationTransportationProvider.displayName;
                }
                else
                {
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE.Value = null;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM.Value = null;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_PROVIDER_DISPLAY_NAME.Value = null;
                }

                if (waitingListItem.EvacuationTransportationType != null)
                {
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE.Value = waitingListItem.EvacuationTransportationType.code;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM.Value = waitingListItem.EvacuationTransportationType.codeSystem;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM_NAME.Value = waitingListItem.EvacuationTransportationType.codeSystemName;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_DISPLAY_NAME.Value = waitingListItem.EvacuationTransportationType.displayName;
                }
                else
                {
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE.Value = null;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM.Value = null;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM_NAME.Value = null;
                    waitingListItemBO.EVACUATION_TRANSPORTATION_TYPE_DISPLAY_NAME.Value = null;
                }

                waitingListItemBO.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER.Value = waitingListItem.EvacuationEnrouteMedicalAttendantNumber;
                waitingListItemBO.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER.Value = waitingListItem.EvacuationEnrouteNonMedicalAttendantNumber;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
