﻿using System;
using System.Linq;
using System.ServiceModel;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorNewEvent
    {
        public static void CopyTo(this NewEventBO newEventBO, DataContracts.NewEvent newEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                newEvent.EventName = (Utils.NewEvent)Enum.Parse(typeof(Utils.NewEvent), newEventBO.EVENT_NAME.Value);
                newEvent.EventCount = newEventBO.EVENT_COUNT.Value.Value;
                newEvent.TotalCount = newEventBO.TOTAL_COUNT.Value.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.NewEvent newEvent, NewEventBO newEventBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                newEventBO.EVENT_NAME.Value = newEvent.EventName.ToString();
                newEventBO.EVENT_COUNT.Value = newEvent.EventCount;
                newEventBO.TOTAL_COUNT.Value = newEvent.TotalCount;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
