﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorIconDetail
    {
        public static void CopyTo(this IconDetailBO iconDetailBO, DataContracts.IconDetail iconDetail)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                iconDetail.Active = (iconDetailBO.ACTIVE.Value.HasValue) ? iconDetailBO.ACTIVE.Value.Value : false;
                iconDetail.Comment = iconDetailBO.COMMENT.Value;
                iconDetail.EnteredBy = iconDetailBO.ENTERED_BY.Value;
                iconDetail.EnteredDate = iconDetailBO.ENTERED_DATE.Value;
                iconDetail.FacilityId = TranslatorUtils.BuildIdentifier(null, iconDetailBO.FACILITY_UID);
                iconDetail.FacilityActive = (iconDetailBO.FACILITY_ACTIVE.Value.HasValue) ? iconDetailBO.FACILITY_ACTIVE.Value.Value : false;
                iconDetail.FacilityComment = iconDetailBO.FACILITY_COMMENT.Value;
                iconDetail.FacilityDescription = iconDetailBO.FACILITY_DESCRIPTION.Value;
                iconDetail.FacilityIconName = iconDetailBO.FACILITY_ICON_NAME.Value;
                iconDetail.FacilityMouseOverText = iconDetailBO.FACILITY_MOUSE_OVER_TEXT.Value;
                iconDetail.FacilityOrderIndex = (iconDetailBO.FACILITY_ORDER_INDEX.Value.HasValue) ? iconDetailBO.FACILITY_ORDER_INDEX.Value.Value : -1;
                iconDetail.FacilityPatientOrRoomBed = iconDetailBO.FACILITY_PATIENT_OR_ROOMBED.Value;                
                iconDetail.Group = iconDetailBO.GROUP.Value;
                iconDetail.IconName = iconDetailBO.ICON_NAME.Value;
                iconDetail.IconType = TranslatorUtils.BuildConcept(iconDetailBO.ICON_TYPE_CODE, iconDetailBO.ICON_TYPE_CODE_SYSTEM, iconDetailBO.ICON_TYPE_CODE_SYSTEM_NAME, iconDetailBO.ICON_TYPE_DISPLAY_NAME);
                iconDetail.Id = iconDetailBO.ID.Value.Value;
                iconDetail.ImageBytes = iconDetailBO.IMAGE_BYTES.Value;
                iconDetail.ImageBytesInactive = iconDetailBO.IMAGE_BYTES_INACTIVE.Value;
                iconDetail.ImageName = iconDetailBO.IMAGE_NAME.Value;                
                iconDetail.LastEditBy = iconDetailBO.LAST_EDIT_BY.Value;
                iconDetail.LastEditDate = iconDetailBO.LAST_EDIT_DATE.Value;
                iconDetail.LongDescription = iconDetailBO.LONG_DESCRIPTION.Value;
                iconDetail.MouseOverText = iconDetailBO.MOUSE_OVER_TEXT.Value;
                iconDetail.OrderIndex = (iconDetailBO.ORDER_INDEX.Value.HasValue) ? iconDetailBO.ORDER_INDEX.Value.Value : -1;
                iconDetail.PatientOrRoomBed = iconDetailBO.PATIENT_OR_ROOMBED.Value;
                iconDetail.ShortDescription = iconDetailBO.SHORT_DESCRIPTION.Value;
                iconDetail.Subgroup = iconDetailBO.SUBGROUP.Value;
                iconDetail.Published = iconDetailBO.PUBLISHED.Value;
                iconDetail.IsAssociated = (iconDetailBO.IS_ASSOCIATED.Value.HasValue) ? iconDetailBO.IS_ASSOCIATED.Value.Value : false;
                iconDetail.IconFlagId = (iconDetailBO.ICON_FLAG_ID.Value.HasValue) ? iconDetailBO.ICON_FLAG_ID.Value.Value : -1;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.IconDetail iconDetail, IconDetailBO iconDetailBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                iconDetailBO.ACTIVE.Value = iconDetail.Active;
                iconDetailBO.COMMENT.Value = iconDetail.Comment;
                iconDetailBO.ENTERED_BY.Value = iconDetail.EnteredBy;
                iconDetailBO.ENTERED_DATE.Value = iconDetail.EnteredDate;
                if (iconDetail.FacilityId != null)
                    iconDetailBO.FACILITY_UID.Value = Guid.Parse(iconDetail.FacilityId.extension);                
                iconDetailBO.FACILITY_ACTIVE.Value = iconDetail.FacilityActive;
                iconDetailBO.FACILITY_COMMENT.Value = iconDetail.FacilityComment;
                iconDetailBO.FACILITY_DESCRIPTION.Value = iconDetail.FacilityDescription;
                iconDetailBO.FACILITY_ICON_NAME.Value = iconDetail.FacilityIconName;
                iconDetailBO.FACILITY_MOUSE_OVER_TEXT.Value = iconDetail.FacilityMouseOverText;
                iconDetailBO.FACILITY_ORDER_INDEX.Value = iconDetail.FacilityOrderIndex;
                iconDetailBO.FACILITY_PATIENT_OR_ROOMBED.Value = iconDetail.FacilityPatientOrRoomBed;                
                iconDetailBO.GROUP.Value = iconDetail.Group;
                iconDetailBO.ICON_NAME.Value = iconDetail.IconName;
                if (iconDetail.IconType != null)
                {
                    iconDetailBO.ICON_TYPE_CODE.Value = iconDetail.IconType.code;
                    iconDetailBO.ICON_TYPE_CODE_SYSTEM.Value = iconDetail.IconType.codeSystem;
                    iconDetailBO.ICON_TYPE_CODE_SYSTEM_NAME.Value = iconDetail.IconType.codeSystemName;
                    iconDetailBO.ICON_TYPE_DISPLAY_NAME.Value = iconDetail.IconType.displayName;
                }
                iconDetailBO.ID.Value = iconDetail.Id;
                iconDetailBO.IMAGE_BYTES.Value = iconDetail.ImageBytes;
                iconDetailBO.IMAGE_BYTES_INACTIVE.Value = iconDetail.ImageBytesInactive;
                iconDetailBO.IMAGE_NAME.Value = iconDetail.ImageName;
                iconDetailBO.LAST_EDIT_BY.Value = iconDetail.LastEditBy;
                iconDetailBO.LAST_EDIT_DATE.Value = iconDetail.LastEditDate;
                iconDetailBO.LONG_DESCRIPTION.Value = iconDetail.LongDescription;
                iconDetailBO.MOUSE_OVER_TEXT.Value = iconDetail.MouseOverText;
                iconDetailBO.ORDER_INDEX.Value = iconDetail.OrderIndex;
                iconDetailBO.PATIENT_OR_ROOMBED.Value = iconDetail.PatientOrRoomBed;
                iconDetailBO.SHORT_DESCRIPTION.Value = iconDetail.ShortDescription;
                iconDetailBO.SUBGROUP.Value = iconDetail.Subgroup;
                iconDetailBO.PUBLISHED.Value = iconDetail.Published;
                iconDetailBO.IS_ASSOCIATED.Value = iconDetail.IsAssociated;
                iconDetailBO.ICON_FLAG_ID.Value = iconDetail.IconFlagId;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
