﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.Utils;
using ePractice.MiddleTier;

namespace BMS.Translators
{
    public static class TranslatorIconAssociation
    {
        public static void CopyTo(this DataContracts.IconAssociation iconAssociation, IconAssociationBO iconAssociationBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (iconAssociation.BedId != null)                
                    iconAssociationBO.BED_UID.Value = Guid.Parse(iconAssociation.BedId.extension);
                else
                    iconAssociationBO.BED_UID.Value = null;
                if (iconAssociation.PatientId != null)
                    iconAssociationBO.PATIENT_UID.Value = Guid.Parse(iconAssociation.PatientId.extension);
                else
                    iconAssociationBO.PATIENT_UID.Value = null;
                if (iconAssociation.FacilityId != null)
                    iconAssociationBO.FACILITY_UID.Value = Guid.Parse(iconAssociation.FacilityId.extension);
                else
                    iconAssociationBO.FACILITY_UID.Value = null;
                if (iconAssociation.ListIconFlagFacilityIdsOfBed != null && iconAssociation.ListIconFlagFacilityIdsOfBed.Count > 0)
                {
                    foreach (int id in iconAssociation.ListIconFlagFacilityIdsOfBed)
                        iconAssociationBO.LIST_ICON_FLAG_FACILITY_IDS_OF_BED.Value += id.ToString() + ",";
                }
                if (iconAssociation.ListIconFlagFacilityIdsOfPatient != null && iconAssociation.ListIconFlagFacilityIdsOfPatient.Count > 0)
                {
                    foreach (int id in iconAssociation.ListIconFlagFacilityIdsOfPatient)
                        iconAssociationBO.LIST_ICON_FLAG_FACILITY_IDS_OF_PATIENT.Value += id.ToString() + ",";
                }
                if (iconAssociation.ListIconFlagIdsOfBed != null && iconAssociation.ListIconFlagIdsOfBed.Count > 0)
                {
                    foreach (int id in iconAssociation.ListIconFlagIdsOfBed)
                        iconAssociationBO.LIST_ICON_FLAG_IDS_OF_BED.Value += id.ToString() + ",";
                }
                if (iconAssociation.ListIconFlagIdsOfPatient != null && iconAssociation.ListIconFlagIdsOfPatient.Count > 0)
                {
                    foreach (int id in iconAssociation.ListIconFlagIdsOfPatient)
                        iconAssociationBO.LIST_ICON_FLAG_IDS_OF_PATIENT.Value += id.ToString() + ",";
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this IconAssociationBO iconAssociationBO, DataContracts.IconAssociation iconAssociation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                iconAssociation.BedId = TranslatorUtils.BuildIdentifier(iconAssociationBO.WAITING_LIST_DOMAIN_ID, iconAssociationBO.BED_UID);
                iconAssociation.PatientId = null;
                iconAssociation.FacilityId = null;

                if (!string.IsNullOrEmpty(iconAssociationBO.LIST_ICON_FLAG_FACILITY_IDS_OF_BED.Value))
                    iconAssociation.ListIconFlagFacilityIdsOfBed = iconAssociationBO.LIST_ICON_FLAG_FACILITY_IDS_OF_BED.Value.Split(',').Select(n => int.Parse(n)).ToList();
                else
                    iconAssociation.ListIconFlagFacilityIdsOfBed = new List<int>();

                if (!string.IsNullOrEmpty(iconAssociationBO.LIST_ICON_FLAG_FACILITY_IDS_OF_PATIENT.Value))
                    iconAssociation.ListIconFlagFacilityIdsOfPatient = iconAssociationBO.LIST_ICON_FLAG_FACILITY_IDS_OF_PATIENT.Value.Split(',').Select(n => int.Parse(n)).ToList();
                else
                    iconAssociation.ListIconFlagFacilityIdsOfPatient = new List<int>();

                if (!string.IsNullOrEmpty(iconAssociationBO.LIST_ICON_FLAG_IDS_OF_BED.Value))
                    iconAssociation.ListIconFlagIdsOfBed = iconAssociationBO.LIST_ICON_FLAG_IDS_OF_BED.Value.Split(',').Select(n => int.Parse(n)).ToList();
                else
                    iconAssociation.ListIconFlagIdsOfBed = new List<int>();

                if (!string.IsNullOrEmpty(iconAssociationBO.LIST_ICON_FLAG_IDS_OF_PATIENT.Value))
                    iconAssociation.ListIconFlagIdsOfPatient = iconAssociationBO.LIST_ICON_FLAG_IDS_OF_PATIENT.Value.Split(',').Select(n => int.Parse(n)).ToList();
                else
                    iconAssociation.ListIconFlagIdsOfPatient = new List<int>();

                if (iconAssociationBO.WAITING_LIST_PATIENT_UID != null)
                    iconAssociation.WaitingListPatientId = TranslatorUtils.BuildIdentifier(iconAssociationBO.WAITING_LIST_DOMAIN_ID, iconAssociationBO.WAITING_LIST_PATIENT_UID);
                else
                    iconAssociation.WaitingListPatientId = null;
                iconAssociation.WaitingListInfo = iconAssociationBO.WAITING_LIST_INFO.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
