﻿using System;
using System.Linq;
using System.ServiceModel;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.Translators
{
    public static class TranslatorDischargeOrder
    {
        public static void CopyTo(this DischargeReqBO dischargeOrderBO, DataContracts.DischargeOrder dischargeOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrEmpty(dischargeOrderBO.FACILITY_LIST.Value))
                {
                    if (dischargeOrderBO.FACILITY_LIST.Value.EndsWith(","))
                        dischargeOrderBO.FACILITY_LIST.Value = dischargeOrderBO.FACILITY_LIST.Value.Substring(0, dischargeOrderBO.FACILITY_LIST.Value.Length - 1);
                    string[] facilityList = dischargeOrderBO.FACILITY_LIST.Value.Split(',');
                    dischargeOrder.FacilityList = new List<II>();
                    for (int i = 0; i < facilityList.Length; i++)
                        dischargeOrder.FacilityList.Add(TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID.Value, facilityList[i]));
                }
                dischargeOrder.HospitalLocationId = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.HOSPITAL_LOCATION_UID);
                dischargeOrder.Id = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.ID);
                dischargeOrder.Ien = dischargeOrderBO.IEN.Value;
                dischargeOrder.IsActive = dischargeOrderBO.IS_ACTIVE.Value;
                dischargeOrder.OrderableItem = TranslatorUtils.BuildConcept(dischargeOrderBO.ORDERABLE_ITEM_CODE, dischargeOrderBO.ORDERABLE_ITEM_CODE_SYSTEM, dischargeOrderBO.ORDERABLE_ITEM_CODE_SYSTEM_NAME, dischargeOrderBO.ORDERABLE_ITEM_DISPLAY_NAME);
                dischargeOrder.OrderedDate = dischargeOrderBO.ORDERED_DATE.Value;
                dischargeOrder.OrderText = dischargeOrderBO.ORDER_TEXT.Value;
                dischargeOrder.PatientId = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.PATIENT_UID);
                dischargeOrder.ProviderId = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.PROVIDER_UID);
                dischargeOrder.ReleasedDate = dischargeOrderBO.RELEASED_DATE.Value;
                dischargeOrder.SchedulerId = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.SCHEDULER_UID);
                dischargeOrder.SignedById = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.SIGNED_BY_UID);
                dischargeOrder.SignedDate = dischargeOrderBO.SIGNED_DATE.Value;
                dischargeOrder.VistaSiteId = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.VISTA_SITE_UID);
                dischargeOrder.WardId = TranslatorUtils.BuildIdentifier(dischargeOrderBO.DOMAIN_ID, dischargeOrderBO.WARD_UID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.DischargeOrder dischargeOrder, DischargeReqBO dischargeOrderBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                dischargeOrderBO.FACILITY_LIST.Value = string.Empty;
                if (dischargeOrder.FacilityList != null && dischargeOrder.FacilityList.Count > 0)
                {
                    foreach (II id in dischargeOrder.FacilityList)
                        dischargeOrderBO.FACILITY_LIST.Value += id.extension + ",";
                }
                if (dischargeOrder.HospitalLocationId != null)
                    dischargeOrderBO.HOSPITAL_LOCATION_UID.Value = Guid.Parse(dischargeOrder.HospitalLocationId.extension);
                if (dischargeOrder.Id != null)
                {
                    dischargeOrderBO.DOMAIN_ID.Value = dischargeOrder.Id.root;
                    int? actId = dischargeOrder.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        dischargeOrderBO.ID.Value = actId.Value;
                }
                dischargeOrderBO.IEN.Value = dischargeOrder.Ien;
                dischargeOrderBO.IS_ACTIVE.Value = dischargeOrder.IsActive;
                if (dischargeOrder.OrderableItem != null)
                {
                    dischargeOrderBO.ORDERABLE_ITEM_CODE.Value = dischargeOrder.OrderableItem.code;
                    dischargeOrderBO.ORDERABLE_ITEM_CODE_SYSTEM.Value = dischargeOrder.OrderableItem.codeSystem;
                    dischargeOrderBO.ORDERABLE_ITEM_CODE_SYSTEM_NAME.Value = dischargeOrder.OrderableItem.codeSystemName;
                    dischargeOrderBO.ORDERABLE_ITEM_DISPLAY_NAME.Value = dischargeOrder.OrderableItem.displayName;
                }
                dischargeOrderBO.ORDERED_DATE.Value = dischargeOrder.OrderedDate;
                dischargeOrderBO.ORDER_TEXT.Value = dischargeOrder.OrderText;
                if (dischargeOrder.PatientId != null)
                    dischargeOrderBO.PATIENT_UID.Value = Guid.Parse(dischargeOrder.PatientId.extension);
                if (dischargeOrder.ProviderId != null)
                    dischargeOrderBO.PROVIDER_UID.Value = Guid.Parse(dischargeOrder.ProviderId.extension);
                dischargeOrderBO.RELEASED_DATE.Value = dischargeOrder.ReleasedDate;
                if (dischargeOrder.SchedulerId != null)
                    dischargeOrderBO.SCHEDULER_UID.Value = System.Guid.Parse(dischargeOrder.SchedulerId.extension);
                if (dischargeOrder.SignedById != null)
                    dischargeOrderBO.SIGNED_BY_UID.Value = System.Guid.Parse(dischargeOrder.SignedById.extension);
                dischargeOrderBO.SIGNED_DATE.Value = dischargeOrder.SignedDate;
                if (dischargeOrder.VistaSiteId != null)
                    dischargeOrderBO.VISTA_SITE_UID.Value = Guid.Parse(dischargeOrder.VistaSiteId.extension);
                if (dischargeOrder.WardId != null)
                    dischargeOrderBO.WARD_UID.Value = Guid.Parse(dischargeOrder.WardId.extension);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
