﻿using System;
using System.Linq;
using System.ServiceModel;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorAdmissionEvent
    {
        public static void CopyTo(this AdmissionEvnBO admissionEventBO, DataContracts.AdmissionEvent admissionEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                admissionEvent.AdmissionDate = admissionEventBO.ADMISSION_DATE.Value;
                admissionEvent.AttendingNurseId = TranslatorUtils.BuildIdentifier(admissionEventBO.DOMAIN_ID, admissionEventBO.ATND_NURSE_UID);
                admissionEvent.BedId = TranslatorUtils.BuildIdentifier(admissionEventBO.DOMAIN_ID, admissionEventBO.BED_UID);                                
                admissionEvent.EnteredById = TranslatorUtils.BuildIdentifier(admissionEventBO.DOMAIN_ID, admissionEventBO.ENTERED_BY_UID);                
                admissionEvent.EnteredDate = admissionEventBO.ENTERED_DATE.Value;
                admissionEvent.HasDischarge = admissionEventBO.HAS_DISCHARGE.Value;
                admissionEvent.Id = TranslatorUtils.BuildIdentifier(admissionEventBO.DOMAIN_ID, admissionEventBO.ID);
                admissionEvent.Ien = admissionEventBO.IEN.Value;
                admissionEvent.MovementType = TranslatorUtils.BuildConcept(admissionEventBO.TYPE_OF_MOVEMENT_CODE, admissionEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM, admissionEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME, admissionEventBO.TYPE_OF_MOVEMENT_DISPLAY_NAME);                
                admissionEvent.PatientId = TranslatorUtils.BuildIdentifier(admissionEventBO.DOMAIN_ID, admissionEventBO.PATIENT_UID);
                admissionEvent.VistaSiteId = TranslatorUtils.BuildIdentifier(admissionEventBO.DOMAIN_ID, admissionEventBO.VISTA_SITE_UID);
                admissionEvent.WardId = TranslatorUtils.BuildIdentifier(admissionEventBO.DOMAIN_ID, admissionEventBO.WARD_UID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.AdmissionEvent admissionEvent, AdmissionEvnBO admissionEventBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                admissionEventBO.ADMISSION_DATE.Value = admissionEvent.AdmissionDate;
                if (admissionEvent.AttendingNurseId != null)
                    admissionEventBO.ATND_NURSE_UID.Value = Guid.Parse(admissionEvent.AttendingNurseId.extension);                
                if (admissionEvent.BedId != null)
                    admissionEventBO.BED_UID.Value = Guid.Parse(admissionEvent.BedId.extension);
                else
                    admissionEventBO.BED_UID.Value = null;
                if (admissionEvent.EnteredById != null)
                    admissionEventBO.ENTERED_BY_UID.Value = Guid.Parse(admissionEvent.EnteredById.extension);
                admissionEventBO.ENTERED_DATE.Value = admissionEvent.EnteredDate;
                admissionEventBO.HAS_DISCHARGE.Value = admissionEvent.HasDischarge;
                if (admissionEvent.Id != null)
                {
                    admissionEventBO.DOMAIN_ID.Value = admissionEvent.Id.root;
                    int? id = admissionEvent.Id.extension.ParseAsInt();
                    if (id.HasValue)
                        admissionEventBO.ID.Value = id.Value;
                }
                admissionEventBO.IEN.Value = admissionEvent.Ien;
                if (admissionEvent.MovementType != null)
                {
                    admissionEventBO.TYPE_OF_MOVEMENT_CODE.Value = admissionEvent.MovementType.code;
                    admissionEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM.Value = admissionEvent.MovementType.codeSystem;
                    admissionEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME.Value = admissionEvent.MovementType.codeSystemName;
                    admissionEventBO.TYPE_OF_MOVEMENT_DISPLAY_NAME.Value = admissionEvent.MovementType.displayName;
                }                
                if (admissionEvent.PatientId != null)
                    admissionEventBO.PATIENT_UID.Value = Guid.Parse(admissionEvent.PatientId.extension);
                if (admissionEvent.VistaSiteId != null)                
                    admissionEventBO.VISTA_SITE_UID.Value = Guid.Parse(admissionEvent.VistaSiteId.extension);
                if (admissionEvent.WardId != null)
                    admissionEventBO.WARD_UID.Value = Guid.Parse(admissionEvent.WardId.extension);
                else
                    admissionEventBO.WARD_UID.Value = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
