﻿using InfoWorld.HL7.ITS;
using BMS.ServiceContracts;
using System.ServiceModel;
using BMS.MT;
using System;
using ePractice.MiddleTier;
using BMS.Translators;
using BMS.Utils;
using System.Transactions;
using BMS.ServiceImplementation.Properties;
using BMS.FaultContracts;
using BMS.ServiceImplementation.Utils;
using System.Collections.Generic;
using System.Linq;
using BMS.DataContracts;
using System.Text;
using BMS.ServicesWrapper.BMService;
using System.Threading;
using BMS.ServicesWrapper.Proxy;
using System.Configuration;

namespace BMS.ServiceImplementation
{
    [ErrorHandlerAttribute]
    [ServiceBehavior(IgnoreExtensionDataObject = true, InstanceContextMode = InstanceContextMode.PerSession, ConcurrencyMode = ConcurrencyMode.Multiple, IncludeExceptionDetailInFaults = true, UseSynchronizationContext = false)]
    public class BedManagerCacheCore : IBedManagerCache
    {
        public void InsertWebClientAddress(string url)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (string.IsNullOrEmpty(url))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "url", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_WEB_CLIENT_ADDRESS_NULL_PARAMETER });

                WebClientAddressBO urlBO = (WebClientAddressBO)MTServices.Instance[Resources.MT_WebClientAddress].CreateNew();
                urlBO.URL.Value = url;
                urlBO.Save();
                urlBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<string> GetWebClientAddresses()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> result = new List<string>();
                bool isIISSingleInstance = bool.Parse(ConfigurationManager.AppSettings["Is_IIS_Single_Instance"]);
                if (isIISSingleInstance)
                {
                    result.Add(string.Empty);
                    return result;
                }
                try
                {
                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_WebClientAddress].GetEntities(null);
                    foreach (WebClientAddressBO bo in listWrapper.ChildList)
                        result.Add(bo.URL.Value);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region EIS

        public void UpdateEISCache(II id, string entityType)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {             
                    client = GetWebCacheProxy(url);                 
                    try
                    {                 
                        client.CacheEisEntity(entityType, id);
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("1. UpdateEISCache entity - " + entityType + ", id = " + id.extension + " for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                switch (entityType)
                {
                    case "Bed":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CacheBed(id);
                        break;
                    case "Ward":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CacheWard(id);
                        break;
                    case "Division":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CacheDivision(id);
                        break;
                    case "Facility":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CacheFacility(id);
                        break;
                    case "VistaSite":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CacheVistaSite(id);
                        break;
                    case "Visn":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CacheVisn(id);
                        break;
                    case "Region":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CacheRegion(id);
                        break;                    
                }
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("2. UpdateEISCache entity - " + entityType + ", id = " + id.extension);
                Tracer.TraceException(ex);
                throw ex;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void RemoveEISCache(II id, string entityType)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {
                    client = GetWebCacheProxy(url);
                    try
                    {
                        client.RemoveCacheEisEntity(entityType, id);
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("1. RemoveEISCache entity - " + entityType + ", id = " + id.extension + " for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                switch (entityType)
                {
                    case "Bed":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.RemoveCacheBed(id);
                        break;
                    case "Ward":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.RemoveCacheWard(id);
                        break;
                    case "Division":
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.RemoveCacheDivision(id);
                        break;                    
                }
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("2. RemoveEISCache entity - " + entityType + ", id = " + id.extension);
                Tracer.TraceException(ex);
                throw ex;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region EVS

        public void UpdateEVSCache(string code, string vocabularyDomain)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {
                    client = GetWebCacheProxy(url);
                    try
                    {
                        client.CacheCD(vocabularyDomain, code);
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("1. UpdateEVSCache vocabulary domain - " + vocabularyDomain + ", code = " + code + " for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                BMS.ServicesWrapper.EVS.EVSFactory.InstanceWindows.CacheCD(vocabularyDomain, code);
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("2. UpdateEVSCache vocabulary domain - " + vocabularyDomain + ", code = " + code);
                Tracer.TraceException(ex);
                throw ex;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void RemoveEVSCache(string code, string vocabularyDomain)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {
                    client = GetWebCacheProxy(url);
                    try
                    {
                        client.RemoveCacheCD(vocabularyDomain, code);
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("1. RemoveEVSCache vocabulary domain - " + vocabularyDomain + ", code = " + code + " for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                BMS.ServicesWrapper.EVS.EVSFactory.InstanceWindows.RemoveCacheCD(vocabularyDomain, code);
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("2. RemoveEVSCache vocabulary domain - " + vocabularyDomain + ", code = " + code);
                Tracer.TraceException(ex);
                throw ex;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        #endregion

        #region Security

        public void ClearUserPermissionCache(string userName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {
                    client = GetWebCacheProxy(url);
                    try
                    {
                        client.ClearUserPermissionCache(userName);
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("ClearUserPermissionCache userName - " + userName + " for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdatePoliciesForOrganizationsCache()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {
                    client = GetWebCacheProxy(url);
                    try
                    {
                        client.CachePoliciesForOrganizations();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("UpdatePoliciesForOrganizationsCache for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        public void UpdateUserRolesCache(InfoWorld.Security.Authorization.PolicyAdministrationPoint.User user)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {
                    client = GetWebCacheProxy(url);
                    try
                    {
                        client.CacheUserRoles(user);
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("UpdateUserRolesCache for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public void RefreshCache()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<string> sites = GetWebClientAddresses();
                BMSCacheOperationsClient client = null;
                foreach (string url in sites)
                {
                    client = GetWebCacheProxy(url);
                    try
                    {
                        client.RefreshCache();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("1. RefreshCache for url= " + url);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.FillCache();
                BMS.ServicesWrapper.EVS.EVSFactory.InstanceWindows.FillCache();
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("2. RefreshCache");
                Tracer.TraceException(ex);
                throw ex;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private BMSCacheOperationsClient GetWebCacheProxy(string url)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {     
                // get the config value for the endpoint
                if (string.IsNullOrEmpty(url))
                {
                    if (bool.Parse(ConfigurationManager.AppSettings["UseCacheEndpointFromConfigWithSsl"]))
                        return BMSFactory.BMSCacheOperationsClientWindowsSsl;
                    else
                        return BMSFactory.BMSCacheOperationsClientWindows;  
                }

                BMSCacheOperationsClient client = null;
                if (url.StartsWith("https:"))
                    client = BMSFactory.BMSCacheOperationsClientWindowsSsl;
                else
                    client = BMSFactory.BMSCacheOperationsClientWindows;
                var serverUri = new Uri(url + "/CacheService.svc");
                client.Endpoint.Address = new EndpointAddress(serverUri, client.Endpoint.Address.Identity, client.Endpoint.Address.Headers);
                client.ChannelFactory.Endpoint.Address = new EndpointAddress(serverUri, client.Endpoint.Address.Identity, client.Endpoint.Address.Headers);
                return client;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
