﻿using System;
namespace BMS.Security.Configuration
{
    /// <summary>
    /// Interface used to acces a DurableIssuedTokenConfigHandler.
    /// </summary>
    public interface IDurableIssuedTokenConfiguration
    {
        /// <summary>
        /// Connection string to the SQL database.
        /// </summary>
        string ConnectionString { get; set; }
        /// <summary>
        /// Security token identifier. Currently limited to the Http SessionID.
        /// </summary>
        DurableIssuedTokenIdentifier Identifier { get; set; }
        /// <summary>
        /// The transaction isolation level used to acces the SQL database. 
        /// Default is ReadCommitted.
        /// </summary>
        System.Transactions.IsolationLevel IsolationLevel { get; set; }
    }
}
