﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel.Configuration;
using System.Configuration;
using System.ComponentModel;
using System.Transactions;
using BMS.Security.DurableIssuedToken;

namespace BMS.Security.Configuration
{
    /// <summary>
    /// ClientCredentialsElement used for application configuration 
    /// of the DurableIssuedTokenClientCredentials.
    /// </summary>
    public class DurableIssuedTokenClientCredentialsConfigHandler : ClientCredentialsElement
    {
        static ConfigurationPropertyCollection _myConfigurationPropertyCollection = null;
        static ConfigurationPropertyCollection _configurationPropertyCollection = null;
        static DurableIssuedTokenClientCredentialsConfigHandler()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _myConfigurationPropertyCollection = new ConfigurationPropertyCollection();
                ConfigurationProperty durableIssuedTokenProperty = new ConfigurationProperty(
                    DurrableIssuedTokenConstants.DURABLE_ISSUED_TOKEN,
                    typeof(DurableIssuedTokenConfigHandler), null,
                    ConfigurationPropertyOptions.IsRequired);
                _myConfigurationPropertyCollection.Add(durableIssuedTokenProperty);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        public DurableIssuedTokenClientCredentialsConfigHandler()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        public override Type BehaviorType
        {
            get { return typeof(DurableIssuedTokenClientCredentials); }
        }
        [ConfigurationProperty(DurrableIssuedTokenConstants.DURABLE_ISSUED_TOKEN)]
        public DurableIssuedTokenConfigHandler DurableIssuedToken
        {
            get { return (DurableIssuedTokenConfigHandler)this[DurrableIssuedTokenConstants.DURABLE_ISSUED_TOKEN]; }
            set { this[DurrableIssuedTokenConstants.DURABLE_ISSUED_TOKEN] = value; }
        }
        protected override object CreateBehavior()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DurableIssuedTokenClientCredentials creds = new DurableIssuedTokenClientCredentials(DurableIssuedToken);
                base.ApplyConfiguration(creds);
                return creds;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected override void DeserializeElement(System.Xml.XmlReader reader, bool serializeCollectionKey)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                base.DeserializeElement(reader, serializeCollectionKey);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        public override void CopyFrom(ServiceModelExtensionElement from)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                base.CopyFrom(from);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected override ConfigurationPropertyCollection Properties
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    if (_configurationPropertyCollection == null)
                    {
                        ConfigurationPropertyCollection rez = base.Properties;
                        foreach (ConfigurationProperty cf in _myConfigurationPropertyCollection)
                            rez.Add(cf);
                        _configurationPropertyCollection = rez;
                    }
                    return _configurationPropertyCollection;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
    }
    /// <summary>
    /// ConfigurationElement used to specify a durableIssuedToken configuration within a custom ClientCredentialsElement
    /// </summary>
    public class DurableIssuedTokenConfigHandler : ConfigurationElement, IDurableIssuedTokenConfiguration
    {
        /// <summary>
        /// Connection string to the SQL database.
        /// </summary>
        [ConfigurationProperty(DurrableIssuedTokenConstants.CONNECTION_STRING, IsRequired = true)]
        [StringValidator(MinLength = 0)]
        public string ConnectionString
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return (string)this[DurrableIssuedTokenConstants.CONNECTION_STRING];
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    this[DurrableIssuedTokenConstants.CONNECTION_STRING] = value;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
        /// <summary>
        /// Security token identifier. Currently limited to the Http SessionID.
        /// </summary>
        [ConfigurationProperty(DurrableIssuedTokenConstants.IDENTIFIER, IsRequired = true)]
        [DefaultValue(DurableIssuedTokenIdentifier.SessionID)]
        public DurableIssuedTokenIdentifier Identifier
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return (DurableIssuedTokenIdentifier)this[DurrableIssuedTokenConstants.IDENTIFIER];
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    this[DurrableIssuedTokenConstants.IDENTIFIER] = value;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
        /// <summary>
        /// The transaction isolation level used to acces the SQL database. Default is ReadCommitted.
        /// </summary>
        [ConfigurationProperty(DurrableIssuedTokenConstants.ISOLATION_LEVEL, IsRequired = false)]
        [DefaultValue(IsolationLevel.ReadCommitted)]
        public IsolationLevel IsolationLevel
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return (IsolationLevel)this[DurrableIssuedTokenConstants.ISOLATION_LEVEL];
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    this[DurrableIssuedTokenConstants.ISOLATION_LEVEL] = value;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }


        static ConfigurationPropertyCollection _myConfigurationPropertyCollection = null;
        static ConfigurationPropertyCollection _configurationPropertyCollection = null;
        static DurableIssuedTokenConfigHandler()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _myConfigurationPropertyCollection = new ConfigurationPropertyCollection();
                ConfigurationProperty connectionStringProperty = new ConfigurationProperty(
                    DurrableIssuedTokenConstants.CONNECTION_STRING,
                    typeof(String), null,
                    ConfigurationPropertyOptions.IsRequired);
                ConfigurationProperty identifierProperty = new ConfigurationProperty(
                    DurrableIssuedTokenConstants.IDENTIFIER,
                    typeof(DurableIssuedTokenIdentifier),
                    DurableIssuedTokenIdentifier.SessionID,
                    ConfigurationPropertyOptions.IsRequired);
                ConfigurationProperty isolationLevelProperty = new ConfigurationProperty(
                    DurrableIssuedTokenConstants.ISOLATION_LEVEL,
                    typeof(System.Transactions.IsolationLevel),
                    IsolationLevel.ReadCommitted,
                    ConfigurationPropertyOptions.IsRequired);

                _myConfigurationPropertyCollection.Add(connectionStringProperty);
                _myConfigurationPropertyCollection.Add(identifierProperty);
                _myConfigurationPropertyCollection.Add(isolationLevelProperty);

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected override ConfigurationPropertyCollection Properties
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    if (_configurationPropertyCollection == null)
                    {
                        ConfigurationPropertyCollection rez = base.Properties;
                        foreach (ConfigurationProperty cf in _myConfigurationPropertyCollection)
                            rez.Add(cf);
                        _configurationPropertyCollection = rez;
                    }
                    return _configurationPropertyCollection;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public DurableIssuedTokenConfigHandler() { }
    }
    public enum DurableIssuedTokenIdentifier { SessionID };

}
