﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.Security;
using BMS.Facade.Data;
using BMS.Schedulers;
using BMS.Schedulers.Managers;

namespace BMS.Numi
{
    public class NumiManager
    {
        private static NumiManager instance = new NumiManager();

        public static NumiManager Instance
        {
            get
            {
                return instance;
            }
        }

        private bool isStarted = false;

        public void Start()
        {
            if (isStarted)
                throw new InvalidOperationException();
            isStarted = true;

            RefreshCommands();
        }

        public void Stop()
        {
            if (!isStarted) return;
            isStarted = false;

            SchedulerManager.Instance.RemoveCommands<NumiCommand>();
        }

        public void RefreshCommands()
        {
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            IList<NumiEntry> numiEntries = Facade.FacadeManager.ConfigurationInterface.GetNumiEntries(domain);
            Dictionary<string, NumiCommand> commands = numiEntries.ToDictionary(s => s.Calendar.Id, s => new NumiCommand(s.Sites));
            SchedulerManager.Instance.SetCommands(commands);
        }


    }
}
