﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Service;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.BMService;
using DC = BMS.DataContracts;
using BMS.Facade.Translators;
using BMS.Facade.Data;
using BMS.Utils;

namespace BMS.Facade.Implementation
{

    public class DiversionOperationsImplementation : IDiversionOperations
    {
        /// <summary>
        /// Gets the diversions.
        /// </summary>
        /// <returns>
        /// List of diversions.
        /// </returns>
        public IList<Diversion> GetDiversions(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Facility facility = FacadeManager.EntityInterface.GetFacility(facilityId);
                return BMSFactory.BedManagerOperationsClient.GetAllDiversion(facilityId)
                                                            .Select<DC.Diversion, Diversion>(dcDiv => DateTimeConverter.ConvertDateFromUTC(dcDiv.ToFacadeContract(facility), facilityId))
                                                            .ToList();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Finds the diversion by id.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <returns></returns>
        public Diversion FindDiversionById(string domain, string id, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Facility facility = FacadeManager.EntityInterface.GetFacility(facilityId);
                var d = BMSFactory.BedManagerOperationsClient.GetDiversion(new II(domain, id));
                Diversion diversion = DateTimeConverter.ConvertDateFromUTC(d.ToFacadeContract(facility), facilityId);
                return diversion;
                //IList<Diversion> diversionList = GetDiversions(facilityId);
                //return diversionList.Where(a => a.Id.extension == id).FirstOrDefault();            
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        /// <summary>
        /// Saves the diversion.
        /// </summary>
        /// <param name="diversion">The diversion.</param>
        /// <param name="isAddOperation">if set to <c>true</c> [is add operation].</param>
        public void SaveDiversion(Diversion diversion, bool isAddOperation, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (isAddOperation)
                    BMSFactory.BedManagerOperationsClient.CreateDiversion(BMOperationsTranslator.ToDataContract(DateTimeConverter.ConvertDateToUTC(diversion, facilityId)));
                else
                    BMSFactory.BedManagerOperationsClient.UpdateDiversion(BMOperationsTranslator.ToDataContract(DateTimeConverter.ConvertDateToUTC(diversion, facilityId)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
