﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using InfoWorld.EVS.CTSMAPI;
  
namespace BMS.Facade.Service
{
    /// <summary>      
    /// Interface used to obtain vocabularies.
    /// </summary>
    public interface IVocabularyOperations
    {
        /// <summary>
        /// Gets the vocabulary.
        /// </summary>
        /// <param name="vocabularyName">Name of the vocabulary.</param>
        /// <returns></returns>
        CDList GetVocabulary(Util.Vocabulary vocabularyName);

        CDList GetVocabularyByVistaCode(Util.Vocabulary vocabularyName, string vistaCode);

        /// <summary>
        /// Allows the insertion of a concept in EVS and updates the underlying ValueSet.
        /// </summary>
        /// <param name="concept">The CD or CDWithProperties concept to insert in EVS. It's inserted in the concept.codeSystem CodeSystem.</param>
        void InsertConcept(CD concept);

        /// <summary>
        /// Updates an existing concept in EVS>
        /// </summary>
        /// <param name="concept">The CD or CDWithProperties concept to updaye in EVS. It's updated based on the code and codeSystem properties.</param>
        void UpdateConcept(CD concept);

        /// <summary>
        /// Deletes an existing concept from EVS.
        /// </summary>
        /// <param name="concept">The concept to delete. Searches for the concept relies on the code and codeSystem properties.</param>
        void DeleteConcept(CD concept);        

        /// <summary>
        /// Gets the unavailable reasons.
        /// </summary>
        /// <returns></returns>
        IList<CDWithProperties> GetReasons();

        /// <summary>
        /// Gets the ADT Orderable Items.
        /// </summary>
        /// <returns></returns>
        IList<CDWithProperties> GetAdtOrderableItems();

		/// <summary>
		/// Gets the time zones.
		/// </summary>
		/// <returns></returns>
		IList<CDWithProperties> GetTimeZones();

        /// <summary>
        /// Gets the vista specialties.
        /// </summary>
        /// <returns></returns>
        List<CDWithProperties> GetVistaSpecialties();

        /// <summary>
        /// Gets the waiting areas.
        /// </summary>
        /// <returns></returns>
        List<CD> GetWaitingAreas();

        /// <summary>
        /// Gets all unavailable reasons.
        /// </summary>
        /// <returns></returns>
        List<CDWithProperties> GetAllUnavailableReasons();

        /// <summary>
        /// Gets the orderable items DB.
        /// </summary>
        /// <param name="vistaCode">The vista code.</param>
        /// <returns></returns>
        List<CD> GetOrderableItemsDB(string vistaCode);

        /// <summary>
        /// Clears the cache.
        /// </summary>
        void ClearCache();
    }
}
