﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Facade.Fault
{
    public class BaseFacadeException : Exception
    {
        String _friendlyMessage = String.Empty;

        public BaseFacadeException(String friendlyMessage)
        {
            _friendlyMessage = friendlyMessage;
        }

        public BaseFacadeException(Exception innerException)
            : base(String.Empty, innerException)
        {
            _friendlyMessage = String.Empty;
        }

        public BaseFacadeException(String friendlyMessage, Exception innerException)
            : base(friendlyMessage, innerException)
        {
            _friendlyMessage = friendlyMessage;
        }

        public override string Message
        {
            get
            {
                Exception exc = this.InnerException;
                StringBuilder sb = new StringBuilder();
                sb.AppendLine(base.Message);

                while (exc != null)
                {

                    sb.AppendLine(exc.Message);
                    exc = exc.InnerException;
                }
                return sb.ToString();
            }
        }

        public string FriendlyMessage
        {
            get
            {
                return _friendlyMessage;
            }
            set
            {
                _friendlyMessage = value;
            }
        }

        public override string StackTrace
        {
            get
            {
                if (String.IsNullOrEmpty(base.StackTrace))
                    return this.InnerException == null ? String.Empty : this.InnerException.StackTrace;

                return base.StackTrace;
            }
        }
    }
}
