﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.ComponentModel;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Util class.
    /// </summary>
    public class Util
    {
        /// <summary>
        /// Contains all vocabulary items used in application.
        /// </summary>
        public enum Vocabulary
        {
            AdminURType,
            ADTOrderableItem,
            UnavailableReason,
            BedBoardModule,
            BedStatus,
            Decision,
            Disposition,
            EMSBedNotification,
            EventType,
            FeeDisposition,
            FeeReason,
            GenderColor,
            Gender,
            Location,
            NationalPatientSortBy,
            OrderableItem,
            OrderableItemType,
            PatientSortBy,
            PatientWaitingTimes,
            PatientWaitingViews,
            PTDisplay,            
            QuickDate,
            Reports,
            SchedAdmNextDays,
            SelectBedGroupingsView,
            SelectReport,
            ServicesReceiving,
            State,
            StrictDecision,
            TimeZone,
            TransactionBed,
            TypeOfBed,
            WaitingArea,
            WaitListView,
            WaitOrderBy,
            VistaSpecialty,
            Era,
            VistaTreatingSpecialty,
            TypeOfMovement,
            VistaMedicalCenterDivision,                  
            Comments,
            ApplicationIcons,
            EvacDispositionStatus,
            TransportationType,
            TransportationProvider,
            NUMA,
            HAvBED
        }

        /// <summary>
        /// Contains all vocabulary items codes used in application.
        /// </summary>
        public enum VocabularyCodes
        {
            [Description("2.12.24.7")]
            AdminURType,
            [Description("2.12.24.34")]
            ADTOrderableItem,
            [Description("2.12.24.33")]
            UnavailableReason,
            [Description("2.12.24.5")]
            BedBoardModule,
            [Description("2.12.24.26")]
            BedStatus,
            [Description("2.12.24.27")]
            Decision,
            [Description("2.12.24.29")]
            Disposition,
            [Description("2.12.24.16")]
            EMSBedNotification,
            [Description("2.12.24.9")]
            EventType,
            [Description("2.12.24.23")]
            FeeDisposition,
            [Description("2.12.24.25")]
            FeeReason,
            [Description("2.12.24.22")]
            GenderColor,
            [Description("2.16.840.1.113883.5.1")]
            Gender,
            [Description("2.12.24.46")]
            Location,
            [Description("2.12.24.42")]
            NationalPatientSortBy,
            [Description("2.12.24.38")]
            OrderableItem,
            [Description("2.12.24.4")]
            OrderableItemType,
            [Description("2.12.24.20")]
            PatientSortBy,
            [Description("2.12.24.10")]
            PatientWaitingTimes,
            [Description("2.12.24.11")]
            PatientWaitingViews,
            [Description("2.12.24.21")]
            PTDisplay,
            [Description("2.12.24.17")]
            QuickDate,
            [Description("2.12.24.19")]
            Reports,
            [Description("2.12.24.14")]
            SchedAdmNextDays,
            [Description("2.12.24.13")]
            SelectBedGroupingsView,
            [Description("2.12.24.12")]
            SelectReport,
            [Description("2.12.24.24")]
            ServicesReceiving,
            [Description("2.12.24.3")]
            State,
            [Description("2.12.24.15")]
            StrictDecision,
            [Description("2.12.24.6")]
            TimeZone,
            [Description("2.12.24.18")]
            TransactionBed,
            [Description("2.12.24.2")]
            TypeOfBed,
            [Description("2.12.24.8")]
            WaitingArea,
            [Description("2.12.24.31")]
            WaitListView,
            [Description("2.12.24.32")]
            WaitOrderBy,
            [Description("2.12.24.39")]
            VistaSpecialty,
            [Description("2.12.24.41")]
            Era,
            [Description("2.12.24.44")]
            VistaTreatingSpecialty,
            [Description("2.12.24.43")]
            TypeOfMovement,
            [Description("2.12.24.47")]
            VistaMedicalCenterDivision,
            [Description("2.12.24.48")]
            Comments,
            [Description("2.12.24.51")]
            ApplicationIcons,
            [Description("2.12.24.52")]
            EvacDispositionStatus,
            [Description("2.12.24.53")]
            TransportationType,
            [Description("2.12.24.54")]
            TransportationProvider,
            [Description("2.12.24.56")]
            NUMA,
            [Description("2.12.24.55")]
            HAvBED 
        }

        /// <summary>
        /// Type of Waiting Time.
        /// </summary>
        public enum PatientWaitingTime
        {
            Current,
            Past30Day,
            Past60Day,
            Past90Day
        }

        public enum NationalPatientSortBy
        {
            Patient,
            Region,
            VISN,
            Speciality,
            RequestDt,
            EventDt
        }

        /// <summary>
        /// Type of severity validation.
        /// </summary>
        public enum Severity
        {
            Information,
            Warning,
            Error,
        }

        /// <summary>
        /// Type of views
        /// </summary>
        public enum View
        {
            Standard,
            FeeUtilization,
            PatientFlow
        }

        /// <summary>
        /// Type of report selection
        /// </summary>
        public enum ReportSelection
        {
            Active,
            SelectionNo1,
            SelectionNo2,
            SelectionNo3,
            SelectionNo4
        }

        public enum EISEntities
        {
            Bed,
            Ward,
            Division,
            Facility,
            VistaSite,
            Visn,
            Region,
            HospitalLocation
        }

        public enum UserRoles
        {
            Administrators, 
            AuditLogUsers, 
            EmsStaff, 
            EMSSupervisorUsers, 
            Guests, 
            NationalUsers, 
            RegionalUsers, 
            SiteUsers, 
            SupportUsers, 
            VisnUsers, 
            SuperUsers            
        }
    }
}
