﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Icon Detail class.
    /// </summary>
    [DataContract]
    public class IconDetail
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>        
        [DataMember]
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the group.
        /// </summary>
        /// <value>
        /// The group.
        /// </value>
        [DataMember]
        public string Group { get; set; }

        /// <summary>
        /// Gets or sets the subgroup.
        /// </summary>
        /// <value>
        /// The subgroup.
        /// </value>
        [DataMember]
        public string Subgroup { get; set; }

        /// <summary>
        /// Gets or sets the type of the icon.
        /// </summary>
        /// <value>
        /// The type of the icon.
        /// </value>
        [DataMember]
        public CD IconType { get; set; }

        /// <summary>
        /// Gets or sets the image bytes.
        /// </summary>
        /// <value>
        /// The image bytes.
        /// </value>
        [DataMember]
        public string ImageBytes { get; set; }

        /// <summary>
        /// Gets or sets the image bytes inactive.
        /// </summary>
        /// <value>
        /// The image bytes inactive.
        /// </value>
        [DataMember]
        public string ImageBytesInactive { get; set; }

        /// <summary>
        /// Gets or sets the index of the order.
        /// </summary>
        /// <value>
        /// The index of the order.
        /// </value>
        [DataMember]
        public int OrderIndex { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="IconDetail"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the name of the image.
        /// </summary>
        /// <value>
        /// The name of the image.
        /// </value>
        [DataMember]
        public string ImageName { get; set; }

        /// <summary>
        /// Gets or sets the name of the icon.
        /// </summary>
        /// <value>
        /// The name of the icon.
        /// </value>
        [DataMember]
        public string IconName { get; set; }

        /// <summary>
        /// Gets or sets the short description.
        /// </summary>
        /// <value>
        /// The short description.
        /// </value>
        [DataMember]
        public string ShortDescription { get; set; }

        /// <summary>
        /// Gets or sets the long description.
        /// </summary>
        /// <value>
        /// The long description.
        /// </value>
        [DataMember]
        public string LongDescription { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [DataMember]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the mouse over text.
        /// </summary>
        /// <value>
        /// The mouse over text.
        /// </value>
        [DataMember]
        public string MouseOverText { get; set; }

        /// <summary>
        /// Gets or sets the patient or room bed.
        /// </summary>
        /// <value>
        /// The patient or room bed.
        /// </value>
        [DataMember]
        public char? PatientOrRoomBed { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [DataMember]
        public Place Facility { get; set; }

        /// <summary>
        /// Gets or sets the name of the facility icon.
        /// </summary>
        /// <value>
        /// The name of the facility icon.
        /// </value>
        [DataMember]
        public string FacilityIconName { get; set; }

        /// <summary>
        /// Gets or sets the facility description.
        /// </summary>
        /// <value>
        /// The facility description.
        /// </value>
        [DataMember]
        public string FacilityDescription { get; set; }

        /// <summary>
        /// Gets or sets the facility comment.
        /// </summary>
        /// <value>
        /// The facility comment.
        /// </value>
        [DataMember]
        public string FacilityComment { get; set; }

        /// <summary>
        /// Gets or sets the facility mouse over text.
        /// </summary>
        /// <value>
        /// The facility mouse over text.
        /// </value>
        [DataMember]
        public string FacilityMouseOverText { get; set; }

        /// <summary>
        /// Gets or sets the facility patient or room bed.
        /// </summary>
        /// <value>
        /// The facility patient or room bed.
        /// </value>
        [DataMember]
        public char? FacilityPatientOrRoomBed { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [facility active].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [facility active]; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool FacilityActive { get; set; }

        /// <summary>
        /// Gets or sets the index of the facility order.
        /// </summary>
        /// <value>
        /// The index of the facility order.
        /// </value>
        [DataMember]
        public int FacilityOrderIndex { get; set; }

        /// <summary>
        /// Gets or sets the entered by.
        /// </summary>
        /// <value>
        /// The entered by.
        /// </value>
        [DataMember]
        public string EnteredBy { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [DataMember]
        public DateTime? EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        [DataMember]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit date.
        /// </summary>
        /// <value>
        /// The last edit date.
        /// </value>
        [DataMember]
        public DateTime? LastEditDate { get; set; }

        /// <summary>
        /// Gets or sets the icon flag id.
        /// </summary>
        /// <value>
        /// The icon flag id.
        /// </value>
        [DataMember]
        public int IconFlagId { get; set; }

        /// <summary>
        /// Gets or sets the published.
        /// </summary>
        /// <value>
        /// The published.
        /// </value>
        [DataMember]
        public bool? Published { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is associated.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is associated; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsAssociated { get; set; }
    }
}
