﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Bed Comment - reason history class.
    /// </summary>
    [DataContract]
    public class BedUnavailableHistory : BedUnavailable
    {

        /// <summary>
        /// Gets or sets the division list.
        /// </summary>
        /// <value>
        /// The division list.
        /// </value>
        [DataMember]
        public List<Division> DivisionList { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [DataMember]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is changed only comment.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is changed only comment; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsChangedOnlyComment { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is clear all.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is clear all; otherwise, <c>false</c>.
        /// </value>
        public bool IsClearAll { get; set; }
    }
}
