﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// BedOutOfService class.
    /// </summary>
    [DataContract]
    public class BedUnavailable : Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the wards.
        /// </summary>
        /// <value>
        /// The wards.
        /// </value>
        [DataMember]        
        public List<Ward> WardList { get; set; }

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [DataMember]
        public Place Bed { get; set; }
        
        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        [DataMember]
        public CD Reason { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        [DataMember]
        public CD Type { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [DataMember]
        public string CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the edited date.
        /// </summary>
        /// <value>
        /// The edited date.
        /// </value>
        [DataMember]
        public DateTime? EditedDate { get; set; }

        /// <summary>
        /// Gets or sets the edited by.
        /// </summary>
        /// <value>
        /// The edited by.
        /// </value>
        [DataMember]
        public string EditedBy { get; set; }

        /// <summary>
        /// Gets or sets the canceled by.
        /// </summary>
        /// <value>
        /// The canceled by.
        /// </value>
        [DataMember]
        public string CanceledBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [out of service vist A].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [out of service vist A]; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool OutOfServiceVistA { get; set; }

        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        [DataMember]
        [ConvertDateTime]
        public Division Division { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        public VistaSite VistaSite { get; set; }

        /// <summary>
        /// Gets or sets the expected completed date (OOS ends for the bed).
        /// </summary>
        /// <value>
        /// The expected completed date.
        /// </value>
        [DataMember]
        public DateTime? ExpectedCompletedDate { get; set; }

        #endregion
    }
}
