﻿using System;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    [DataContract]
    public class BedStaffHistory
    {        
        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>        
        [DataMember]
        public Place Bed { get; set; }
        
        /// <summary>
        /// Gets or sets the staff.
        /// </summary>
        /// <value>
        /// The staff.
        /// </value>        
        [DataMember]
        public string Staff { get; set; }
        
        /// <summary>
        /// Gets or sets the transaction type code.
        /// </summary>
        /// <value>
        /// The transaction type code.
        /// </value>        
        [DataMember]
        public string TransactionTypeCode { get; set; }

        /// <summary>
        /// Gets or sets the creation date.
        /// </summary>
        /// <value>
        /// The creation date.
        /// </value>
        [DataMember]
        public DateTime? CreationDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [DataMember]
        public string CreatedBy { get; set; }
    }
}
