using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Transactions;
using IsolationLevel=System.Data.IsolationLevel;
using System.Threading;

namespace InfoWorld.WMI_UserGroup
{
    /// <summary>
    /// Class is used to update a dataset.
    /// </summary>
    public static class SqlUtil
    {
        /// <summary>
        /// Update the specified datasets.
        /// </summary>
        /// <param name="dSetsData">The _d sets data.</param>
        public static void ExecuteUpdate(List<DataSet> dSetsData)
        {
			TransactionOptions transactionOptions = new TransactionOptions();
			if (Transaction.Current != null && Transaction.Current.IsolationLevel != System.Transactions.IsolationLevel.ReadCommitted)
				transactionOptions.IsolationLevel = Transaction.Current.IsolationLevel;
			else
				transactionOptions.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;
			using (TransactionScope tr = new TransactionScope(TransactionScopeOption.Required, transactionOptions))
            {
                foreach (DataSet dsData in dSetsData)
                {
                    string sDataSetName = dsData.ToString();
                    string[] sTableNames = ePractice.AdapterRepository.Util.GetTableNames(sDataSetName);

                    foreach (string sTableName in sTableNames)
                    {
                        SqlDataAdapter daTable = ePractice.AdapterRepository.Util.GetDataAdapter(sDataSetName, sTableName);
                        int i = daTable.UpdateBatchSize;
                        daTable.UpdateBatchSize = 100;
                        if (daTable.UpdateCommand != null)
                            daTable.UpdateCommand.UpdatedRowSource = UpdateRowSource.OutputParameters;
                        if (daTable.InsertCommand != null)
                            daTable.InsertCommand.UpdatedRowSource = UpdateRowSource.OutputParameters;
                        if (daTable.DeleteCommand != null)
                            daTable.DeleteCommand.UpdatedRowSource = UpdateRowSource.OutputParameters;

                        daTable.Update(dsData, sTableName);

                        daTable.UpdateBatchSize = i;
                    }
                }
                tr.Complete();
            }
        }

        /// <summary>
        /// Update the specified dataset.
        /// </summary>
        /// <param name="dsData">The data.</param>
        public static void ExecuteUpdate(DataSet dsData)
        {
			TransactionOptions transactionOptions = new TransactionOptions();
			if (Transaction.Current != null && Transaction.Current.IsolationLevel != System.Transactions.IsolationLevel.ReadCommitted)
				transactionOptions.IsolationLevel = Transaction.Current.IsolationLevel;
			else
				transactionOptions.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;
			using (TransactionScope tr = new TransactionScope(TransactionScopeOption.Required, transactionOptions))
            {
                string sDataSetName = dsData.ToString();
                string[] sTableNames = ePractice.AdapterRepository.Util.GetTableNames(sDataSetName);

                foreach (string sTableName in sTableNames)
                {
                    SqlDataAdapter daTable = ePractice.AdapterRepository.Util.GetDataAdapter(sDataSetName, sTableName);
                    int i = daTable.UpdateBatchSize;
                    daTable.UpdateBatchSize = 100;
                    if (daTable.UpdateCommand != null)
                        daTable.UpdateCommand.UpdatedRowSource = UpdateRowSource.OutputParameters;
                    if (daTable.InsertCommand != null)
                        daTable.InsertCommand.UpdatedRowSource = UpdateRowSource.OutputParameters;
                    if (daTable.DeleteCommand != null)
                        daTable.DeleteCommand.UpdatedRowSource = UpdateRowSource.OutputParameters;

                    daTable.Update(dsData, sTableName);

                    daTable.UpdateBatchSize = i;
                }
                tr.Complete();
            }
        }

        public static void FillData(DataSet dsParameters, DataSet dsData)
        {
            FillData(dsParameters, dsData, -1);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="dsParameters"></param>
        /// <param name="dsData"></param>
        /// <param name="timeOut">max fill duration milisecunde</param>
        public static void FillData(DataSet dsParameters, DataSet dsData, int timeOut)
        {
            SqlDataAdapter daFirstTable = GetDataAdapter(dsParameters, dsData);
            int __iOriginalTimeout = daFirstTable.SelectCommand.CommandTimeout;
            try
            {
                if (timeOut > 0)
                    daFirstTable.SelectCommand.CommandTimeout = timeOut / 1000 + 1;

                int tries = 0;
                bool filled = false;
                do
                {
                    try
                    {
                        daFirstTable.Fill(dsData);
                        filled = true;
                    }
                    catch (SqlException ex)
                    {

                        if (++tries > maxRetries)
                            throw;
                        if (!CanRetrySqlException(ex))
                        {
                            if (CanRetryTransaction(ex))
                            {
                                Thread.Sleep(500);
                                daFirstTable = GetDataAdapter(dsParameters, dsData);
                            }
                            else
                                throw;
                        }
                    }
                    catch (TransactionException ex)
                    {
                        if (++tries > maxRetries)
                            throw;
                        if (!CanRetryTransaction(ex))
                            throw;
                        Thread.Sleep(500);
                        daFirstTable = GetDataAdapter(dsParameters, dsData);
                    }
                } while (!filled);
            }
            finally
            {
                daFirstTable.SelectCommand.CommandTimeout = __iOriginalTimeout;
            }
        }

        private static SqlDataAdapter GetDataAdapter(DataSet dsParameters, DataSet dsData)
        {
            string sDataSetName = dsData.ToString();
            string[] sTableNames = ePractice.AdapterRepository.Util.GetTableNames(sDataSetName);
            foreach (string sTableName in sTableNames)
            {
                SqlDataAdapter daFirstTable = ePractice.AdapterRepository.Util.GetDataAdapter(sDataSetName, sTableName);
                if (daFirstTable.SelectCommand == null)
                    continue;
                if (daFirstTable.SelectCommand.Parameters.Count > 0)
                {
                    DataRow drParameters = dsParameters.Tables[0].Rows[0];
                    for (int i = 0; i < daFirstTable.SelectCommand.Parameters.Count; i++)
                    {
                        daFirstTable.SelectCommand.Parameters[i].Value = drParameters[i];
                    }
                }
                for (int i = 0; i < sTableNames.Length; i++)
                {
                    daFirstTable.TableMappings.Add("Table" + (i == 0 ? "" : i.ToString()), sTableNames[i]);
                }
                return daFirstTable;
            }

            return null;
        }

        private static bool CanRetrySqlException(System.Data.SqlClient.SqlException ex)
        {
            if (ex.Message.Equals("Timeout expired.  The timeout period elapsed prior to completion of the operation or the server is not responding."))
                return true;
            if (ex.Message.EndsWith("was deadlocked on lock resources with another process and has been chosen as the deadlock victim. Rerun the transaction."))
                return true;
            //if (ex.Message.Contains("New request is not allowed to start because it should come with valid transaction descriptor."))
            //    return true;
            return false;
        }

        private static bool CanRetryTransaction(System.Exception ex)
        {
            if (ex is System.Data.SqlClient.SqlException)
            {
                if (ex.Message.Equals("Timeout expired.  The timeout period elapsed prior to completion of the operation or the server is not responding."))
                    return true;
                if (ex.Message.EndsWith("was deadlocked on lock resources with another process and has been chosen as the deadlock victim. Rerun the transaction."))
                    return true;
                if (ex.Message.Contains("New request is not allowed to start because it should come with valid transaction descriptor."))
                    return true;
                if (ex.Message.Contains("A transport-level error has occurred when sending the request to the server."))
                    return true;
                if (ex.Message.Contains("An error has occurred while establishing a connection to the server."))
                    return true;
            }
            if (ex is System.Transactions.TransactionException)
                return true;
            return false;
        }

        private static int maxRetries = 4;

    }
}
