using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Reflection;

namespace InfoWorld.WMI_UserGroup
{
    /// <summary>
    /// This class is used to write log file.
    /// </summary>
    public static class Log
    {
        private static TraceSource traceErrors;

        /// <summary>
        /// Initializes the Log class.
        /// </summary>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1810:InitializeReferenceTypeStaticFieldsInline")]
        static Log()
        {
            traceErrors = new TraceSource("WMI_UserGroup");
        }

        /// <summary>
        /// Write the exception.
        /// </summary>
        /// <param name="exception">The exc.</param>
        public static void LogException(Exception exception)
        {
            try
            {
                StackTrace stackTrace = new StackTrace(true);
                StackFrame stackFrame = stackTrace.GetFrame(1);
                MethodBase method = stackFrame.GetMethod();
                string message = "\n--------OccuringTime:    " + DateTime.Now.ToString() + "   ------------\n";
                message += "File:     " + stackFrame.GetFileName() + "\n";
                message += "Method:   " + method.ReflectedType.ToString() + "." + method.Name + "\n";
                Exception parseException = exception;
                while (parseException != null)
                {
                    message += "Exception:\n";
                    message += "\t\tType:       " + parseException.GetType().ToString() + "\n";
                    message += "\t\tMessage:    " + parseException.Message + "\n";
                    message += "\t\tStackTrace: " + parseException.StackTrace + "\n";
                    parseException = parseException.InnerException;
                }
                message += "------------------------------------------------------------\n\n";
                traceErrors.TraceEvent(TraceEventType.Error, 0, message);
            }
            catch { }
        }

        /// <summary>
        /// Write the message.
        /// </summary>
        /// <param name="message">The message.</param>
        public static void LogMessage(string message)
        {
            try
            {              
                string msg = "\n--------LogTime:    " + DateTime.Now.ToString() + "   ------------\n";
                msg += "\t\tMessage:    " + message + "\n";
                msg += "------------------------------------------------------------\n\n";
                traceErrors.TraceEvent(TraceEventType.Information, 0, msg);
            }
            catch { }
        }
    }
}
