﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class SpecialtyController : Controller
    {
        #region Get Methods

        // GET: /Specialty/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<SPECIALTY> list = new List<SPECIALTY>();
                foreach (SPECIALTY spec in db.SPECIALTies.ToList())
                {
                    list.Add(spec);
                }
                return View(list);
            }
        }

        //Get: /Specialty/Create
        public ActionResult Create()
        {
            return View();
        }

        // GET: /Specialty/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.SPECIALTies.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /Specialty/Create
        [HttpPost]
        public ActionResult Create(SPECIALTY spec)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.SPECIALTies.Add(spec);
                    db.SaveChanges();
                }

                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, SPECIALTY spec)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(spec).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
