﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class PatientController : Controller
    {
        #region Get Methods

        // GET: /Patient/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<PATIENT> patientList = new List<PATIENT>();
                foreach (PATIENT patient in db.PATIENTs.ToList())
                {
                    if (patient.TREATING_SPECIALTY_ID != null)
                        patient.TREATING_SPECIALTY_NAME = db.FAC_TREAT_SPECIALTY.Where(a => a.IEN == patient.TREATING_SPECIALTY_ID).Select(a => a.NAME).FirstOrDefault();
                    else
                        patient.TREATING_SPECIALTY_NAME = string.Empty;

                    if (patient.ATTENDING_PHYSICIAN_ID != null)
                        patient.ATTENDING_PHYSICIAN_NAME = db.NEW_PERSON.Where(a => a.IEN == patient.ATTENDING_PHYSICIAN_ID).Select(a => a.NAME).FirstOrDefault();
                    else
                        patient.ATTENDING_PHYSICIAN_NAME = string.Empty;

                    patientList.Add(patient);
                }
                return View(patientList);
            }
        }

        // GET: /Patient/Create/
        public ActionResult Create()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["TreatingSpecialty"] = db.FAC_TREAT_SPECIALTY.ToList();
                ViewData["AttendingPhysicianList"] = db.NEW_PERSON.ToList();
            }
            return View();
        }

        // GET: /Patient/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["TreatingSpecialty"] = db.FAC_TREAT_SPECIALTY.ToList();
                ViewData["AttendingPhysicianList"] = db.NEW_PERSON.ToList();
                return View(db.PATIENTs.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /Patient/Create
        [HttpPost]
        public ActionResult Create(PATIENT patient)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.PATIENTs.Add(patient);
                    db.SaveChanges();
                }
                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }

            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["TreatingSpecialty"] = db.FAC_TREAT_SPECIALTY.ToList();
                ViewData["AttendingPhysicianList"] = db.NEW_PERSON.ToList();
            }
            return View();
        }

        // POST: /Patient/Edit/id

        [HttpPost]
        public ActionResult Edit(int id, PATIENT patient)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(patient).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }

            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["TreatingSpecialty"] = db.FAC_TREAT_SPECIALTY.ToList();
                ViewData["AttendingPhysicianList"] = db.NEW_PERSON.ToList();
            }
            return View();
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion
    }
}
