USE V03BYNBMSDB
DECLARE @FACILITY_CODE NVARCHAR(10), @CD_CODE NVARCHAR(20), @VISTA_CODE NVARCHAR(20), @FACILITY_UID UNIQUEIDENTIFIER, @VISTA_ID INT, @VISTA_SITE_UID UNIQUEIDENTIFIER
SET @FACILITY_CODE = 'BYN'
SELECT @VISTA_CODE = V.IDENTIFIER_EXTENSION, @FACILITY_UID = E.IDENTIFIER, @VISTA_ID = V.FK_ENTITY,
	@VISTA_SITE_UID = VSE.IDENTIFIER
FROM BMS_EIS.dbo.ENTITY AS E 
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN BMS_EIS.dbo.ENTITY AS VSE ON V.FK_ENTITY = VSE.PK_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'
SET @CD_CODE = @VISTA_CODE + '_' + @FACILITY_CODE + '_'


DECLARE @COUNT_UREASON_FROM_BMS_DATABASE INT, @COUNT_UREASON_FROM_LOCAL_DATABASE INT, @COUNT_WAREA_FROM_BMS_DATABASE INT, @COUNT_WAREA_FROM_LOCAL_DATABASE INT

SELECT @COUNT_UREASON_FROM_BMS_DATABASE = COUNT(*)
FROM BMS_EVS.dbo.conceptProperty 
WHERE codingSchemeName = 'UnavailableReason' AND conceptCode LIKE '' + @CD_CODE + '' + '%' AND property = 'textualPresentation'

;WITH BED_CONTROL_UREASON_CTE AS
(
  SELECT @CD_CODE + REPLACE(REPLACE(LTRIM(RTRIM(UREASON.UReasonText)), ' ', '_'),'''','_') AS CODE, REPLACE(UREASON.UReasonText, '''','''''') AS DISPLAY_NAME,
	CP.conceptCode AS CD_TYPE,
	ROW_NUMBER() OVER(PARTITION BY UREASON.UReasonText ORDER BY UREASON.UReasonText) AS RN
  FROM [dbo].[Bed_Control_UReason] AS UREASON
  INNER JOIN BMS_EVS.[dbo].[conceptProperty] AS CP ON CP.propertyValue = UREASON.UReasonType
  WHERE CP.codingSchemeName = 'AdminURType' AND CP.property = 'textualPresentation'
) 
 
SELECT @COUNT_UREASON_FROM_LOCAL_DATABASE = COUNT(*)
FROM BED_CONTROL_UREASON_CTE
WHERE RN = 1

IF @COUNT_UREASON_FROM_BMS_DATABASE = @COUNT_UREASON_FROM_LOCAL_DATABASE
	BEGIN
	  SELECT 'UNAVAILABLE REASON SUCCESSFULLY IMPORTED.'
	END
ELSE
	BEGIN
	  SELECT 'UNAVAILABLE REASON UNSUCCESSFULLY IMPORTED.'
	END

SELECT @COUNT_WAREA_FROM_BMS_DATABASE = COUNT(*)
FROM BMS_EVS.dbo.conceptProperty 
WHERE codingSchemeName = 'WaitingArea' AND conceptCode LIKE '' + @CD_CODE + '' + '%' AND property = 'textualPresentation'
		
;WITH BED_CONTROL_WAITAREA_CTE AS
(
  SELECT @CD_CODE + REPLACE(REPLACE(LTRIM(RTRIM(WaitAreaName)), ' ', '_'),'''','''''') AS CODE, ISNULL(REPLACE(WaitAreaName, '''',''''''),'') AS DISPLAY_NAME,
	ROW_NUMBER() OVER(PARTITION BY WaitAreaName ORDER BY WaitAreaName) AS RN
  FROM [dbo].[Bed_Control_Wait_Area]
) 

SELECT @COUNT_WAREA_FROM_LOCAL_DATABASE = COUNT(*)
FROM BED_CONTROL_WAITAREA_CTE
WHERE RN = 1

IF @COUNT_WAREA_FROM_BMS_DATABASE = @COUNT_WAREA_FROM_LOCAL_DATABASE
	BEGIN
	  SELECT 'WAITING AREA SUCCESSFULLY IMPORTED.'
	END
ELSE
	BEGIN
	  SELECT 'WAITING AREA UNSUCCESSFULLY IMPORTED.'
	END


DECLARE @COUNT_ADTOrderableItem_FROM_BMS_DATABASE INT, @COUNT_ADTOrderableItem_FROM_LOCAL_DATABASE INT
SELECT @COUNT_ADTOrderableItem_FROM_BMS_DATABASE = COUNT(*)
FROM BMS_EVS.dbo.conceptProperty 
WHERE codingSchemeName = 'ADTOrderableItem' AND conceptCode LIKE '' + @CD_CODE + '' + '%' AND property = 'textualPresentation'

;WITH BED_CONTROL_ADTORDERABLEITEM_CTE AS
(
  SELECT @CD_CODE + CAST(ADT.OIIEN AS NVARCHAR(20)) AS CODE,  REPLACE(ADT.OIName, '','''') AS DISPLAY_NAME,
	CP.conceptCode AS CD_TYPE,
	ROW_NUMBER() OVER(PARTITION BY ADT.OIIEN ORDER BY ADT.OIIEN) AS RN
  FROM [Bed_Control_ADT_OI] AS ADT
  INNER JOIN BMS_EVS.[dbo].[conceptProperty] AS OrderableItem on OrderableItem.conceptCode = @VISTA_CODE + '_'  + CAST(ADT.OIIEN AS NVARCHAR(20)) AND REPLACE(OrderableItem.propertyValue, '','''') = REPLACE(ADT.OIName, '','''')
  INNER JOIN BMS_EVS.[dbo].[conceptProperty] AS CP ON CP.propertyValue = ADT.OIType
  WHERE OrderableItem.codingSchemeName = 'OrderableItem' AND CP.codingSchemeName = 'OrderableItemType' AND CP.property = 'textualPresentation'
) 

SELECT @COUNT_ADTOrderableItem_FROM_LOCAL_DATABASE = count(*)
FROM BED_CONTROL_ADTORDERABLEITEM_CTE
WHERE RN = 1 

IF @COUNT_ADTOrderableItem_FROM_BMS_DATABASE = @COUNT_ADTOrderableItem_FROM_LOCAL_DATABASE
	BEGIN
	  SELECT 'ADTOrderableItem SUCCESSFULLY IMPORTED.'
	END
ELSE
	BEGIN
	  SELECT 'ADTOrderableItem UNSUCCESSFULLY IMPORTED.'
	END
	
	
CREATE TABLE #WARDS(WARD_NAME NVARCHAR(250), WARD_ID UNIQUEIDENTIFIER, WARD_PK INT, DIVISION_PK INT, DIVISION_NAME NVARCHAR(250), WARD_IEN NUMERIC)
INSERT INTO #WARDS (WARD_NAME, WARD_ID, WARD_PK, WARD_IEN)
SELECT P.NAME, E.IDENTIFIER, P.PFK_PLACE, CAST(T.IDENTIFIER_EXTENSION AS NUMERIC)
FROM BMS_EIS.dbo.EHL7_PLACE AS P
	INNER JOIN BMS_EIS.dbo.ENTITY AS E ON P.PFK_PLACE = E.PK_ENTITY
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = P.PFK_PLACE AND R.CLASS_CODE = 'OWN'
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS T ON T.FK_ENTITY = R.FK_PLAYER_ENTITY AND T.IDENTIFIER_ROOT = 'IEN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @VISTA_ID 

;WITH CTE_EXISTING_WARDGROUP(WARD_PK, DIVISION_NAME, DIVISION_ID, DIVISION_PK) AS
(
	SELECT DISTINCT RWD.FK_PLAYER_ENTITY, O.NAME, E.IDENTIFIER, O.PFK_ORGANIZATION
	FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O
	INNER JOIN BMS_EIS.dbO.ENTITY AS E ON O.PFK_ORGANIZATION = E.PK_ENTITY
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS RFAC ON O.PFK_ORGANIZATION = RFAC.FK_PLAYER_ENTITY AND RFAC.CLASS_CODE = 'MBR'
	INNER JOIN BMS_EIS.dbO.ENTITY AS FAC ON RFAC.FK_SCOPER_ENTITY = FAC.PK_ENTITY
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS RWD ON RWD.FK_SCOPER_ENTITY = O.PFK_ORGANIZATION AND RWD.CLASS_CODE = 'SDLOC'
	WHERE O.CODE_CODE = 'WGR' AND FAC.IDENTIFIER = @FACILITY_UID
)

UPDATE O
	SET 
		DIVISION_PK = DIVISION.DIVISION_PK,
		DIVISION_NAME = DIVISION.DIVISION_NAME
FROM #WARDS AS O
INNER JOIN CTE_EXISTING_WARDGROUP AS DIVISION ON DIVISION.WARD_PK = O.WARD_PK
		
		
DELETE FROM #WARDS WHERE DIVISION_PK IS NULL

CREATE TABLE #BEDS(BED_ID UNIQUEIDENTIFIER, BED_PK INT, WARD_PK INT, DIVISION_PK INT, ROLE_PK INT)
INSERT INTO #BEDS(BED_ID, BED_PK, WARD_PK, DIVISION_PK, ROLE_PK)
SELECT DISTINCT E.IDENTIFIER, E.PK_ENTITY, R.FK_SCOPER_ENTITY, R1.FK_SCOPER_ENTITY, R2.PK_ROLE
FROM BMS_EIS.dbo.EHL7_PLACE AS P
	INNER JOIN BMS_EIS.dbo.ENTITY AS E ON P.PFK_PLACE = E.PK_ENTITY
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = P.PFK_PLACE AND R.CLASS_CODE = 'LOCE'
	LEFT JOIN BMS_EIS.dbo.EHL7_ROLE AS R1 ON R1.FK_PLAYER_ENTITY = R.FK_SCOPER_ENTITY AND R1.CLASS_CODE = 'SDLOC'
	LEFT JOIN BMS_EIS.dbo.EHL7_ROLE AS R2 ON R2.FK_PLAYER_ENTITY = P.PFK_PLACE AND R2.FK_SCOPER_ENTITY = R1.FK_SCOPER_ENTITY AND R2.CLASS_CODE = 'MNT'
WHERE P.CODE_CODE = 'BED' AND R.FK_SCOPER_ENTITY IN (SELECT WARD_PK FROM #WARDS)

DECLARE @COUNT_WARD_FROM_BMS INT, @COUNT_WARD_FROM_LOCAL_BMS INT, @COUNT_BED_WITHOUT_DIVISION INT

SELECT @COUNT_WARD_FROM_BMS = COUNT(*)
FROM #WARDS AS BMS
--INNER JOIN Bed_Control_Ward_Param AS LOCAL_BMS ON LOCAL_BMS.VistaWardName = BMS.WARD_NAME AND LOCAL_BMS.WardGroupText = BMS.WARD_NAME

SELECT @COUNT_WARD_FROM_LOCAL_BMS = COUNT(*)
FROM
(
	SELECT DISTINCT VistaWardName, WardGroupText
	FROM Bed_Control_Ward_Param
) T


IF @COUNT_WARD_FROM_BMS = @COUNT_WARD_FROM_LOCAL_BMS
	BEGIN
		SELECT 'ASSOCIATION BETWEEN (WARD - WARD GROUP) SUCCESSFULLY IMPORTED.'
	END
ELSE
	BEGIN
		DECLARE @COUNT_INVALID_WARD INT
		
		SELECT @COUNT_INVALID_WARD = COUNT(*) 
		FROM Bed_Control_Ward_Param AS LOCAL_WARD 
		LEFT OUTER JOIN #WARDS AS WARD ON WARD.WARD_IEN = LOCAL_WARD.IEN
		WHERE WARD.WARD_IEN IS NULL
		
		SET @COUNT_WARD_FROM_LOCAL_BMS = @COUNT_WARD_FROM_LOCAL_BMS + @COUNT_INVALID_WARD
		IF @COUNT_WARD_FROM_BMS = @COUNT_WARD_FROM_LOCAL_BMS
			BEGIN
				SELECT 'IN LOCAL BMS DATABASE (CLASS 3) ARE: ' + @COUNT_INVALID_WARD + ' WARDS THAT ARE NOT FOUND IN BMS DATABASE (CLASS 1).'
				SELECT 'ASSOCIATION BETWEEN (WARD - WARD GROUP) SUCCESSFULLY IMPORTED.'
			END
		ELSE
			BEGIN
				SELECT 'ASSOCIATION BETWEEN (WARD - WARD GROUP) UNSUCCESSFULLY IMPORTED.'
			END
	END

SELECT @COUNT_BED_WITHOUT_DIVISION = COUNT(*) FROM #BEDS WHERE DIVISION_PK IS NULL

IF @COUNT_BED_WITHOUT_DIVISION = 0
	BEGIN
		SELECT 'ASSOCIATION BETWEEN (BED - WARD GROUP) SUCCESSFULLY IMPORTED.'
	END
ELSE
	BEGIN
		SELECT 'ASSOCIATION BETWEEN (BED - WARD GROUP) UNSUCCESSFULLY IMPORTED.'
	END

drop table #BEDS
drop table #WARDS

DECLARE @COUNT_HOSPITAL_LOCATION_FROM_BMS INT, @COUNT_HOSPITAL_LOCATION_FROM_LOCAL_BMS INT

SELECT @COUNT_HOSPITAL_LOCATION_FROM_BMS = COUNT(*)
FROM BMS.dbo.HOSPITAL_LOCATION_APPOINTMENT
WHERE FACILITY_UID = @FACILITY_UID

SELECT @COUNT_HOSPITAL_LOCATION_FROM_LOCAL_BMS = COUNT(*)
FROM Bed_Control_Discharge_Clinic

IF @COUNT_HOSPITAL_LOCATION_FROM_BMS = @COUNT_HOSPITAL_LOCATION_FROM_LOCAL_BMS
	BEGIN
		SELECT 'HOSPITAL LOCATION SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		DECLARE @COUNT_INVALID_HOSPITAL_LOCATION INT
		
		SELECT @COUNT_INVALID_HOSPITAL_LOCATION = COUNT(*)
		FROM Bed_Control_Discharge_Clinic AS DC
		LEFT OUTER JOIN ( 
		SELECT C.IDENTIFIER_EXTENSION AS IEN
		FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O 
		INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.FK_SCOPER_ENTITY = @VISTA_ID AND CLASS_CODE = 'MBR'
		INNER JOIN BMS_EIS.dbo.EHL7_UID AS C ON C.FK_ENTITY = O.PFK_ORGANIZATION AND C.IDENTIFIER_ROOT = 'IEN'
		WHERE O.CODE_CODE = 'HLOC') C ON C.IEN = DC.DCIEN
		WHERE C.IEN IS NULL
		
		SET @COUNT_HOSPITAL_LOCATION_FROM_LOCAL_BMS = @COUNT_HOSPITAL_LOCATION_FROM_LOCAL_BMS + @COUNT_INVALID_HOSPITAL_LOCATION
		IF @COUNT_HOSPITAL_LOCATION_FROM_BMS = @COUNT_HOSPITAL_LOCATION_FROM_LOCAL_BMS
			BEGIN
				SELECT 'IN LOCAL BMS DATABASE (CLASS 3) ARE: ' + @COUNT_INVALID_HOSPITAL_LOCATION + ' LOCATIONS THAT ARE NOT FOUND IN BMS DATABASE (CLASS 1).'
				SELECT 'HOSPITAL LOCATION SUCCESSFULLY IMPORTED'
			END
		ELSE
		 	BEGIN
				SELECT 'HOSPITAL LOCATION UNSUCCESSFULLY IMPORTED'
			END
	END