/*
	Before running the script - replace the name of the databases where:
		1. CURRENT_BMS_EIS - the name of the BMS_EIS database (SOURCE);
		2. CURRENT_BMS_EVS - the name of the BMS_EVS database (SOURCE);
		3. BMS_EIS - the name of the BMS_EIS database (DESTINATION);
		4. BMS_EVS - the name of the BMS_EVS database (DESTINATION);
*/

DECLARE @FACILITY_CODE NVARCHAR(20), @VISTA_CODE NVARCHAR(20), @EVS_VISTA_FACILITY_CODE NVARCHAR(50), @EVS_VISTA_CODE NVARCHAR(25)
SET @VISTA_CODE = 'V01BHS'
SET @FACILITY_CODE = 'BRK'
SET @EVS_VISTA_FACILITY_CODE = @VISTA_CODE + '_' + @FACILITY_CODE + '_'
SET @EVS_VISTA_CODE = @VISTA_CODE + '_'

DECLARE @SOURCE_FOUND_CONCEPT INT, @DESTINATION_FOUND_CONCEPT INT,
	    @SOURCE_FOUND_CONCEPT_PROPERTY INT, @DESTINATION_FOUND_CONCEPT_PROPERTY INT,
	    @SOURCE_FOUND_VOC_VALUE_NESTED_SET INT, @DESTINATION_FOUND_VOC_VALUE_NESTED_SET INT

--count from concept table
SELECT @SOURCE_FOUND_CONCEPT = COUNT(*)
FROM CURRENT_BMS_EVS.dbo.concept
WHERE codingSchemeName IN ('VistaSpecialty', 'Era')

SELECT @DESTINATION_FOUND_CONCEPT = COUNT(*)
FROM BMS_EVS.dbo.concept
WHERE codingSchemeName IN ('VistaSpecialty', 'Era')

SELECT @SOURCE_FOUND_CONCEPT = @SOURCE_FOUND_CONCEPT + COUNT(*)
FROM CURRENT_BMS_EVS.dbo.concept
WHERE codingSchemeName IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND conceptCode LIKE ''+ @EVS_VISTA_CODE +'%'

SELECT @DESTINATION_FOUND_CONCEPT = @DESTINATION_FOUND_CONCEPT + COUNT(*)
FROM BMS_EVS.dbo.concept
WHERE codingSchemeName IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND conceptCode LIKE ''+ @EVS_VISTA_CODE +'%'
	  
SELECT @SOURCE_FOUND_CONCEPT = @SOURCE_FOUND_CONCEPT + COUNT(*)
FROM CURRENT_BMS_EVS.dbo.concept
WHERE codingSchemeName IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND conceptCode LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'

SELECT @DESTINATION_FOUND_CONCEPT = @DESTINATION_FOUND_CONCEPT + COUNT(*)
FROM BMS_EVS.dbo.concept
WHERE codingSchemeName IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND conceptCode LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'
	  
--count from conceptProperty table
SELECT @SOURCE_FOUND_CONCEPT_PROPERTY = COUNT(*)
FROM CURRENT_BMS_EVS.dbo.conceptProperty
WHERE codingSchemeName IN ('VistaSpecialty', 'Era')

SELECT @DESTINATION_FOUND_CONCEPT_PROPERTY = COUNT(*)
FROM BMS_EVS.dbo.conceptProperty
WHERE codingSchemeName IN ('VistaSpecialty', 'Era')

SELECT @SOURCE_FOUND_CONCEPT_PROPERTY = @SOURCE_FOUND_CONCEPT_PROPERTY + COUNT(*)
FROM CURRENT_BMS_EVS.dbo.conceptProperty
WHERE codingSchemeName IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND conceptCode LIKE ''+ @EVS_VISTA_CODE +'%'

SELECT @DESTINATION_FOUND_CONCEPT_PROPERTY = @DESTINATION_FOUND_CONCEPT_PROPERTY + COUNT(*)
FROM BMS_EVS.dbo.conceptProperty
WHERE codingSchemeName IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND conceptCode LIKE ''+ @EVS_VISTA_CODE +'%'
	  
SELECT @SOURCE_FOUND_CONCEPT_PROPERTY = @SOURCE_FOUND_CONCEPT_PROPERTY + COUNT(*)
FROM CURRENT_BMS_EVS.dbo.conceptProperty
WHERE codingSchemeName IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND conceptCode LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'

SELECT @DESTINATION_FOUND_CONCEPT_PROPERTY = @DESTINATION_FOUND_CONCEPT_PROPERTY + COUNT(*)
FROM BMS_EVS.dbo.conceptProperty
WHERE codingSchemeName IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND conceptCode LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'
	  
--count from voc_nested_value_set table
SELECT @SOURCE_FOUND_VOC_VALUE_NESTED_SET = COUNT(*)
FROM CURRENT_BMS_EVS.dbo.voc_nested_value_set
WHERE codingSchemeName IN ('VistaSpecialty', 'Era')

SELECT @DESTINATION_FOUND_VOC_VALUE_NESTED_SET = COUNT(*)
FROM BMS_EVS.dbo.voc_nested_value_set
WHERE codingSchemeName IN ('VistaSpecialty', 'Era')

SELECT @SOURCE_FOUND_VOC_VALUE_NESTED_SET = @SOURCE_FOUND_VOC_VALUE_NESTED_SET + COUNT(*)
FROM CURRENT_BMS_EVS.dbo.voc_nested_value_set
WHERE codingSchemeName IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND conceptCode LIKE ''+ @EVS_VISTA_CODE +'%'

SELECT @DESTINATION_FOUND_VOC_VALUE_NESTED_SET = @DESTINATION_FOUND_VOC_VALUE_NESTED_SET + COUNT(*)
FROM BMS_EVS.dbo.voc_nested_value_set
WHERE codingSchemeName IN ('OrderableItem', 'VistaTreatingSpecialty' , 'TypeOfMovement', 'VistaMedicalCenterDivision')
	  AND conceptCode LIKE ''+ @EVS_VISTA_CODE +'%'
	  
SELECT @SOURCE_FOUND_VOC_VALUE_NESTED_SET = @SOURCE_FOUND_VOC_VALUE_NESTED_SET + COUNT(*)
FROM CURRENT_BMS_EVS.dbo.voc_nested_value_set
WHERE codingSchemeName IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND conceptCode LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'

SELECT @DESTINATION_FOUND_VOC_VALUE_NESTED_SET = @DESTINATION_FOUND_VOC_VALUE_NESTED_SET + COUNT(*)
FROM BMS_EVS.dbo.voc_nested_value_set
WHERE codingSchemeName IN ('WaitingArea', 'UnavailableReason', 'ADTOrderableItem')
	  AND conceptCode LIKE ''+ @EVS_VISTA_FACILITY_CODE +'%'
	  
IF (@SOURCE_FOUND_CONCEPT = @DESTINATION_FOUND_CONCEPT AND @SOURCE_FOUND_CONCEPT_PROPERTY = @DESTINATION_FOUND_CONCEPT_PROPERTY
	AND @SOURCE_FOUND_VOC_VALUE_NESTED_SET = @DESTINATION_FOUND_VOC_VALUE_NESTED_SET)
	BEGIN
		SELECT 'BMS_EVS DATABASE SUCCESFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BMS_EVS DATABASE UNSUCCESFULLY IMPORTED'
		select @SOURCE_FOUND_CONCEPT
		select @DESTINATION_FOUND_CONCEPT
		select @SOURCE_FOUND_CONCEPT_PROPERTY
		select @DESTINATION_FOUND_CONCEPT_PROPERTY
		select @SOURCE_FOUND_VOC_VALUE_NESTED_SET
		select @DESTINATION_FOUND_VOC_VALUE_NESTED_SET
	END
	
 