﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace Import_VistaJob
{
    public class ThreadManager
    {
        int itemCount = 0;

        public delegate void AllItemsCompleteHandler();
        public event AllItemsCompleteHandler
            OnAllItemsComplete;

        public delegate void ItemCompleteHandler
            (MethodContainer container);
        public event ItemCompleteHandler
            OnItemComplete;

        public void QueueItem(WaitCallback callback, object state)
        {
            Interlocked.Increment(ref itemCount);

            MethodContainer container =
                new MethodContainer(callback, state);

            ThreadPool.QueueUserWorkItem(new WaitCallback(ExecuteItem),
                container);
        }

        public void WaitForItemsToComplete()
        {
            //wait for itemCount to equal 0.
            while (itemCount != 0) ;
        }

        private void ExecuteItem(object containerObject)
        {
            MethodContainer container =
                (MethodContainer)containerObject;

            container.ExecuteMethod();

            ItemComplete(container);
        }

        private void ItemComplete(MethodContainer container)
        {
            Interlocked.Decrement(ref itemCount);

            if (OnItemComplete != null)
                OnItemComplete(container);

            if (itemCount == 0 && OnAllItemsComplete != null)
                OnAllItemsComplete();
        }
    }
}
