SELECT	E.IDENTIFIER AS 'IDENTIFIER',
		O.NAME AS 'NAME',
		U.IDENTIFIER_EXTENSION AS 'CODE',
		V_NO.IDENTIFIER_EXTENSION AS 'VISN',
		R_NO.IDENTIFIER_EXTENSION AS 'REGION'		
FROM EHL7_ORGANIZATION AS O
	INNER JOIN ENTITY AS E ON O.PFK_ORGANIZATION = E.PK_ENTITY	
	INNER JOIN EHL7_UID AS U ON O.PFK_ORGANIZATION = U.FK_ENTITY AND U.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN EHL7_ROLE AS R_VS ON O.PFK_ORGANIZATION = R_VS.FK_PLAYER_ENTITY AND R_VS.CLASS_CODE = 'MBR'	
	INNER JOIN EHL7_ROLE AS R_V ON R_VS.FK_SCOPER_ENTITY = R_V.FK_PLAYER_ENTITY AND R_V.CLASS_CODE = 'MBR'
	INNER JOIN EHL7_ROLE AS R_R ON R_V.FK_SCOPER_ENTITY = R_R.FK_PLAYER_ENTITY AND R_R.CLASS_CODE = 'MBR'
	INNER JOIN EHL7_UID AS R_NO ON R_R.FK_SCOPER_ENTITY = R_NO.FK_ENTITY AND R_NO.IDENTIFIER_ROOT = 'NUMBER'
	INNER JOIN EHL7_UID AS V_NO ON R_V.FK_SCOPER_ENTITY = V_NO.FK_ENTITY AND V_NO.IDENTIFIER_ROOT = 'NUMBER'
WHERE O.CODE_CODE = 'FAC'


