﻿using System;
using System.Data.SqlClient;
using System.Data;
using System.Configuration;

namespace ImportUsers
{
    public class GlobalConnections
    {
        static SqlConnection configConnection;
        static SqlConnection eisConnection;
        static SqlConnection authzConnection;
        static SqlConnection importConnection;

        public static SqlConnection ConfigConnection
        {
            get
            {
                if (configConnection != null && (configConnection.State == ConnectionState.Broken || configConnection.State == ConnectionState.Closed))
                {
                    configConnection.Dispose();
                    configConnection = null;
                }
                if (configConnection == null)
                {
                    configConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["ConfigConnString"].ConnectionString);
                    configConnection.Open();
                }
                return configConnection;
            }
            set
            {
                configConnection = value;
            }
        }

        public static SqlConnection EisConnection
        {
            get
            {
                if (eisConnection != null && (eisConnection.State == ConnectionState.Broken || eisConnection.State == ConnectionState.Closed))
                {
                    eisConnection.Dispose();
                    eisConnection = null;
                }
                if (eisConnection == null)
                {
                    eisConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["EISConnString"].ConnectionString);
                    eisConnection.Open();
                }
                return eisConnection;
            }
            set
            {
                eisConnection = value;
            }
        }

        public static SqlConnection AuthzConnection
        {
            get
            {
                if (authzConnection != null && (authzConnection.State == ConnectionState.Broken || authzConnection.State == ConnectionState.Closed))
                {
                    authzConnection.Dispose();
                    authzConnection = null;
                }
                if (authzConnection == null)
                {
                    authzConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["AUTHZConnString"].ConnectionString);
                    authzConnection.Open();
                }
                return authzConnection;
            }
            set
            {
                authzConnection = value;
            }
        }

        public static SqlConnection ImportConnection
        {
            get
            {
                if (importConnection != null && (importConnection.State == ConnectionState.Broken || importConnection.State == ConnectionState.Closed))
                {
                    importConnection.Dispose();
                    importConnection = null;
                }
                if (importConnection == null)
                {
                    importConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["ImportUsersConnString"].ConnectionString);
                    importConnection.Open();
                }
                return importConnection;
            }
            set
            {
                importConnection = value;
            }
        }

        public static void CloseConnections()
        {
            if (configConnection != null)
            {
                configConnection.Close();
                configConnection.Dispose();
            }
            if (eisConnection != null)
            {
                eisConnection.Close();
                eisConnection.Dispose();
            }
            if (authzConnection != null)
            {
                authzConnection.Close();
                authzConnection.Dispose();
            }
            if (importConnection != null)
            {
                importConnection.Close();
                importConnection.Dispose();
            }
        }
    }
}
