DECLARE @SQL NVARCHAR(MAX), @FACILITY_CODE NVARCHAR(10),@FACILITY_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT @FACILITY_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

		CREATE TABLE #BEDS(BED_UID UNIQUEIDENTIFIER)
		INSERT INTO #BEDS(BED_UID)
		SELECT DISTINCT BED_UID FROM BMS.dbo.BED_STAFF WHERE FACILITY_UID = @FACILITY_UID

		--delete from BMS database 
		DELETE FROM BMS.dbo.BED_STAFF WHERE FACILITY_UID = @FACILITY_UID

		DELETE FROM BMS_HISTORY.dbo.BED_STAFF_H WHERE FACILITY_UID = @FACILITY_UID

		--upadate trait
		SET @SQL = NULL
		SELECT @SQL = COALESCE(@SQL,'') + '
			exec BMS_EIS.[dbo].[UPD_TRAIT_VALUE]
			 @ENTITY_IDENTIFIER= ''' + CONVERT(NVARCHAR(50), BED.BED_UID) + ''',
			 @DOMAIN_IDENTIFIER=N''InfoWorld'',
			 @ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',
			 @TRAIT_IDENTIFIER=N''NURSE_ASSIGNMENT'',
			 @TRAIT_VALUE_STRING=NULL,
			 @TRAIT_VALUE_REAL=NULL,
			 @TRAIT_VALUE_INTEGER=NULL,
			 @TRAIT_VALUE_DATETIME=NULL,
			 @TRAIT_VALUE_BYTE=NULL'
		FROM #BEDS AS BED
		EXEC sp_executesql @SQL
		
		DROP TABLE #BEDS
		
	SELECT 'STAFF - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;