DECLARE @VISTA_UID UNIQUEIDENTIFIER, @VISTA_CODE NVARCHAR(10)
BEGIN TRY
	BEGIN TRANSACTION;
		SET @VISTA_CODE = '$(varVISTACode)'
		SELECT @VISTA_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
		WHERE O.NAME = @VISTA_CODE AND CODE_CODE ='VST'

		CREATE TABLE #AEVN_DEL(ID INT)
		CREATE TABLE #AREQ_DEL(ID INT)
		CREATE TABLE #ALEVEL_OF_CARE_DEL(ID INT)
		CREATE TABLE #BS_DEL(ID INT)
		CREATE TABLE #DINT_DEL(ID INT)
		CREATE TABLE #DREQ_DEL(ID INT)
		CREATE TABLE #DEVN_DEL(ID INT)
		CREATE TABLE #MREQ_DEL(ID INT)
		CREATE TABLE #MEVN_DEL(ID INT)
		CREATE TABLE #SA_DEL(ID INT)
		CREATE TABLE #ST_DEL(ID INT)
		CREATE TABLE #ORDER_DEL(ID INT)

		--DISCHARGE INTENT
		INSERT INTO #DINT_DEL(ID)
		SELECT ID FROM BMS.dbo.DISCHARGE_EVN WHERE VISTA_SITE_UID = @VISTA_UID

		--DISCHARGE REQ
		INSERT INTO #DREQ_DEL(ID)
		SELECT ID FROM BMS.dbo.DISCHARGE_REQ WHERE VISTA_SITE_UID = @VISTA_UID

		--DISCHARGE EVN
		INSERT INTO #DEVN_DEL(ID)
		SELECT ID FROM BMS.dbo.DISCHARGE_EVN WHERE VISTA_SITE_UID = @VISTA_UID

		--TRANSFER EVN
		INSERT INTO #MEVN_DEL(ID)
		SELECT ID FROM BMS.dbo.MOVEMENT_EVN WHERE VISTA_SITE_UID = @VISTA_UID

		--TRANSFER REQ
		INSERT INTO #MREQ_DEL(ID)
		SELECT ID FROM BMS.dbo.MOVEMENT_REQ WHERE VISTA_SITE_UID = @VISTA_UID

		--ADMISSION REQ
		INSERT INTO #AREQ_DEL(ID)
		SELECT ID FROM BMS.dbo.ADMISSION_REQ WHERE VISTA_SITE_UID = @VISTA_UID

		--ASMISSION EVN
		INSERT INTO #AEVN_DEL(ID)
		SELECT ID FROM BMS.dbo.ADMISSION_EVN WHERE VISTA_SITE_UID = @VISTA_UID

		--LEVEL OF CARE
		INSERT INTO #ALEVEL_OF_CARE_DEL(ID)
		SELECT ALOC.ID FROM BMS.dbo.ADMISSION_LEVEL_OF_CARE AS ALOC
		INNER JOIN #AEVN_DEL AS EVN ON EVN.ID = ALOC.ADMISSION_ID

		--BED SWITCH
		INSERT INTO #BS_DEL(ID)
		SELECT BS.ID FROM BMS.dbO.BED_SWITCH AS BS 
		INNER JOIN #AEVN_DEL AS AEVN ON AEVN.ID = BS.ADMISSION_ID

		--SCHEDULED ADMISSION
		INSERT INTO #SA_DEL(ID)
		SELECT ID FROM BMS.dbo.SCHEDULED_ADMISSION WHERE VISTA_SITE_UID = @VISTA_UID

		--SPECIALTY TRANSFER
		INSERT INTO #ST_DEL(ID)
		SELECT ST.ID FROM BMS.dbo.SPECIALTY_TRANSFER AS ST
		INNER JOIN #AEVN_DEL AS AEVN ON AEVN.ID = ST.ADMISSION_ID

		--ORDER
		INSERT INTO #ORDER_DEL(ID)
		SELECT O.ID FROM BMS.dbo.ORDER_FACILITY AS O 
		INNER JOIN #DREQ_DEL AS REQ ON REQ.ID = O.ORDER_ID 
		WHERE O.ORDER_TYPE = 'DIS'
		UNION 
		SELECT O.ID FROM BMS.dbo.ORDER_FACILITY AS O 
		INNER JOIN #AREQ_DEL AS REQ ON REQ.ID = O.ORDER_ID 
		WHERE O.ORDER_TYPE = 'ADM'
		UNION 
		SELECT O.ID FROM BMS.dbo.ORDER_FACILITY AS O 
		INNER JOIN #MREQ_DEL AS REQ ON REQ.ID = O.ORDER_ID 
		WHERE O.ORDER_TYPE = 'TRA'

		--DELETE ORDER
		DELETE ORDER_FAC FROM BMS.dbo.ORDER_FACILITY AS ORDER_FAC
		INNER JOIN #ORDER_DEL AS O_DEL ON O_DEL.ID = ORDER_FAC.ID

		DELETE ORDER_FAC FROM BMS_HISTORY.dbo.ORDER_FACILITY_H AS ORDER_FAC
		INNER JOIN #ORDER_DEL AS O_DEL ON O_DEL.ID = ORDER_FAC.ID

		DROP TABLE #ORDER_DEL

		--DELETE DISCHARGE INTENT
		DELETE DINT FROM BMS.dbo.DISCHARGE_INT AS DINT
		INNER JOIN #DINT_DEL AS DINT_DEL ON DINT_DEL.ID = DINT.ID

		DELETE DINT FROM BMS_HISTORY.dbo.DISCHARGE_INT_H AS DINT
		INNER JOIN #DINT_DEL AS DINT_DEL ON DINT_DEL.ID = DINT.ID

		DROP TABLE #DINT_DEL

		--DELETE REQUEST
		--DISCHARGE
		DELETE DREQ FROM BMS.dbo.DISCHARGE_REQ AS DREQ
		INNER JOIN #DREQ_DEL AS DREQ_DEL ON DREQ_DEL.ID = DREQ.ID

		DELETE DREQ FROM BMS_HISTORY.dbo.DISCHARGE_REQ_H AS DREQ
		INNER JOIN #DREQ_DEL AS DREQ_DEL ON DREQ_DEL.ID = DREQ.ID

		DROP TABLE #DREQ_DEL

		--MOVEMETN
		DELETE TREQ FROM BMS.dbo.MOVEMENT_REQ AS TREQ
		INNER JOIN #MREQ_DEL AS MREQ_DEL ON MREQ_DEL.ID = TREQ.ID

		DELETE TREQ FROM BMS_HISTORY.dbo.MOVEMENT_REQ_H AS TREQ
		INNER JOIN #MREQ_DEL AS MREQ_DEL ON MREQ_DEL.ID = TREQ.ID

		DROP TABLE #MREQ_DEL

		--ADMISSION
		DELETE AREQ FROM BMS.dbo.ADMISSION_REQ AS AREQ
		INNER JOIN #AREQ_DEL AS AREQ_DEL ON AREQ_DEL.ID = AREQ.ID

		DELETE AREQ FROM BMS_HISTORY.dbo.ADMISSION_REQ_H AS AREQ
		INNER JOIN #AREQ_DEL AS AREQ_DEL ON AREQ_DEL.ID = AREQ.ID

		DROP TABLE #AREQ_DEL

		--DELETE EVENT
		--DELETE SCHEDULED ADMISSION
		DELETE SA FROM BMS.dbo.SCHEDULED_ADMISSION AS SA
		INNER JOIN #SA_DEL AS DEL ON DEL.ID = SA.ID

		DELETE SA FROM BMS_HISTORY.dbo.SCHEDULED_ADMISSION_H AS SA
		INNER JOIN #SA_DEL AS DEL ON DEL.ID = SA.ID

		DROP TABLE #SA_DEL

		--DELETE SPECIALTY TRANSFER
		DELETE ST FROM BMS.dbo.SPECIALTY_TRANSFER AS ST
		INNER JOIN #ST_DEL AS DEL ON DEL.ID = ST.ID

		DELETE ST FROM BMS_HISTORY.dbo.SPECIALTY_TRANSFER_H AS ST
		INNER JOIN #ST_DEL AS DEL ON DEL.ID = ST.ID

		DROP TABLE #ST_DEL

		--DELETE ADMISISON LEVEL OF CARE
		DELETE ALOC FROM BMS.dbo.ADMISSION_LEVEL_OF_CARE AS ALOC
		INNER JOIN #ALEVEL_OF_CARE_DEL AS DEL ON DEL.ID = ALOC.ID

		DELETE ALOC FROM BMS_HISTORY.dbo.ADMISSION_LEVEL_OF_CARE_H AS ALOC
		INNER JOIN #ALEVEL_OF_CARE_DEL AS DEL ON DEL.ID = ALOC.ID

		DROP TABLE #ALEVEL_OF_CARE_DEL

		-- DELETE DISCHARGE
		DELETE DEVN FROM BMS.dbo.DISCHARGE_EVN AS DEVN
		INNER JOIN #DEVN_DEL AS DEL ON DEL.ID = DEVN.ID

		DELETE DEVN FROM BMS_HISTORY.dbo.DISCHARGE_EVN_H AS DEVN
		INNER JOIN #DEVN_DEL AS DEL ON DEL.ID = DEVN.ID

		DROP TABLE #DEVN_DEL

		--DELETE BED SWITCH
		DELETE BS FROM BMS.dbo.BED_SWITCH AS BS
		INNER JOIN #BS_DEL AS DEL ON DEL.ID = BS.ID

		DELETE BS FROM BMS_HISTORY.dbo.BED_SWITCH_H AS BS
		INNER JOIN #BS_DEL AS DEL ON DEL.ID = BS.ID

		DROP TABLE #BS_DEL

		--DELETE MOVEMENT
		DELETE MEVN FROM BMS.dbo.MOVEMENT_EVN AS MEVN
		INNER JOIN #MEVN_DEL AS DEL ON DEL.ID = MEVN.ID

		DELETE MEVN FROM BMS_HISTORY.dbo.MOVEMENT_EVN_H AS MEVN
		INNER JOIN #MEVN_DEL AS DEL ON DEL.ID = MEVN.ID

		DROP TABLE #MEVN_DEL

		--DELETE ADMISSION
		DELETE AEVN FROM BMS.dbo.ADMISSION_EVN AS AEVN
		INNER JOIN #AEVN_DEL AS DEL ON DEL.ID = AEVN.ID

		DELETE AEVN FROM BMS_HISTORY.dbo.ADMISSION_EVN_H AS AEVN
		INNER JOIN #AEVN_DEL AS DEL ON DEL.ID = AEVN.ID

		DROP TABLE #AEVN_DEL

		--delete person
		CREATE TABLE #PERSON(ID INT)
		INSERT INTO #PERSON(ID)
		SELECT P.PFK_PERSON FROM BMS_EIS.dbo.EHL7_PERSON AS P
		INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON P.PFK_PERSON = R.FK_PLAYER_ENTITY AND R.CLASS_CODE = 'PROV'
		INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = P.PFK_PERSON
		where u.IDENTIFIER_ROOT = 'SITE' AND u.IDENTIFIER_EXTENSION = @VISTA_UID
			
		--DELETE ROLE
		DELETE ROL FROM BMS_EIS.dbo.EHL7_ROLE AS ROL
		INNER JOIN #PERSON AS DEL ON DEL.ID = ROL.FK_PLAYER_ENTITY

		--DELETE TRAIT
		DELETE TV FROM BMS_EIS.dbo.TRAIT_VALUE AS TV
		INNER JOIN #PERSON AS DEL ON DEL.ID = TV.FK_ENTITY

		--DELETE UID
		DELETE OUID FROM BMS_EIS.dbo.EHL7_UID AS OUID
		INNER JOIN #PERSON AS DEL ON DEL.ID = OUID.FK_ENTITY
		
		--DELETE PERSON
		DELETE P FROM BMS_EIS.dbo.EHL7_PERSON AS P
		INNER JOIN #PERSON AS DEL ON DEL.ID = P.PFK_PERSON
		
		--DELETE ENTITY
		DELETE E FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN #PERSON AS DEL ON DEL.ID = E.PK_ENTITY
		DROP TABLE #PERSON

		--DROP VISTA INTEGRATION LOG AND VISTA OPERATION
		DELETE FROM BMS.dbo.VISTA_OPERATIONS WHERE VISTA_ID = @VISTA_UID AND OPERATION_ID = 16
		DELETE FROM BMS.dbo.VISTA_INTEGRATION_LOG WHERE VISTA = @VISTA_CODE AND (VISTA_FILE = 'OR' OR VISTA_FILE ='PM' OR VISTA_FILE ='SA' OR VISTA_FILE = 'PA')
	SELECT 'ADT - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
