﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace BMSConfigurationWarlock
{
    internal static class Constants
    {
        public const string Versions = "Versions";
        public const string DefaultVersion = "DefaultVersion";
        public const string PreferredServicesPort = "PreferredServicesPort";
        public const string PreferredServicesServer = "PreferredServicesServer";
        public const string PreferredDatabaseServer = "PreferredDatabaseServer";
        public const string PreferredApplicationName = "PreferredApplicationName";
        public const string PreferredWebServer = "PreferredWebServer";
        public const string PreferredServicesPrefix = "PreferredServicesPrefix";
        public const string SuggestedServicesLocation = "SuggestedServicesLocation";
        public const string SuggestedSiteLocation = "SuggestedSiteLocation";
        public const string AppDomain = "AppDomain";
        public const string SuperUsersList = "SuperUsers";
        public const string MainWindowCloseMessageContent = "MainWindowCloseMessageContent";
        public const string ConfigurationWarlockMainWindow = "ConfigurationWarlockMainWindow";
        public const string ErrorWindow = "ErrorWindow";
        public const string ConfigsNotFoundMessageContent = "ConfigsNotFoundMessageContent";
        public const string DatabaseConnectionsFailedMessageContent = "DatabaseConnectionsFailedMessageContent";
        public const string SuccessWindow = "SuccessWindow";
        public const string DatabaseConnectionsSucceededMessageContent = "DatabaseConnectionsSucceededMessageContent";
        public const string DSConfigurationsSucceededMessageContent = "DSConfigurationsSucceededMessageContent";
        public const string DSConfigurationsFailedMessageContent = "DSConfigurationsFailedMessageContent";
        public const string DWConfigurationsSucceededMessageContent = "DWConfigurationsSucceededMessageContent";
        public const string DWConfigurationsFailedMessageContent = "DWConfigurationsFailedMessageContent";
        public const string HistoryTriggersConfigurationSucceededMessageContent = "HistoryTriggersConfigurationSucceededMessageContent";
        public const string HistoryTriggersConfigurationFailedMessageContent = "HistoryTriggersConfigurationFailedMessageContent";
        public const string DatabaseConnectionsNotTestedContent = "DatabaseConnectionsNotTestedContent";
        public const string UpdateReportsSucceededMessageContent = "UpdateReportsSucceededMessageContent";
        public const string ConfigurationFilesNotFound = "ConfigurationFilesNotFound";
        public const string DatasetPath = "DatasetPath";
        public const string ConnectionsXml = "connections.xml";
        public const string SuggestedDatabaseNamePattern = "SuggestedDatabaseNamePattern";
        public const string SqlConnectionString = "workstation id={0};packet size=4096;data source={0};persist security info=False;initial catalog={1};Integrated Security=SSPI;";
        public const string SqlScriptsFolder = "SqlScripts";
        public const string SqlScriptsToRun = "SqlScriptsToRun";
        public const string GetDatabaseVersionSql = "SqlScripts\\GetDatabaseVersion.sql";
        public const string BMSReports = "BMS_REPORTS";
        public const string DataSource = "Data Sources";
        public const string HttpsPortOffset = "HttpsPortOffset";
        public const string ServiceOperationTimeoutSeconds = "ServiceOperationTimeoutSeconds";
        public const string ServiceDidNotRespondInATimelyFashion = "ServiceDidNotRespondInATimelyFashion";
        public const string ExecutableExtension = ".exe";

        public const string ServicesConfigurationXml = "Definitions\\ServicesConfiguration.xml";
        public const string DatabasesConfigurationXml = "Definitions\\DatabasesConfiguration.xml";
        public const string ConfigurationFileNotFound = "ConfigurationFileNotFound";
        public const string ConnectionStringAddPathInConfig = "//connectionStrings/add";
        public const string ConnectionString = "connectionString";
        public const string Name = "name";
        public const string ReportsUserDomain = "ReportsUserDomain";
        public const string ReportsRootFolder = "ReportsRootFolder";
        public const string ReportsUserName = "ReportsUserName";
        public const string ReportsUserPassword = "ReportsUserPassword";
        public const string ReportingServicesUrl = "ReportingServicesUrl";
        public const string UserPasswordDomainFormat = "{0}|{1}|{2}";
        public const string BMSiteAssemblyName = "BMS.Web.dll";
        public const string BMSDWDatabaseKey = "DW";
        public const string WebConfig = "Web.config";
        public const string DatabaseVersionIncorrect = "DatabaseVersionIncorrect";
        public const string DatabaseVersionNoVersion = "DatabaseVersionNoVersion";
        public const string varNewServer = "varNewServer";
        public const string varNewServicesEndpoint = "varNewServicesEndpoint";
        public const string varNewDBs = "varNewDBs";

        public const string sqlCmd = "sqlcmd";

        //parsing constants
        public const string Key = "key";
        public const string Value = "value";
        public const string AuditServer = "AuditServer";
        public const string AuditPort = "AuditPort";
        public const string ReportingServicesUserPasswordDomain = "user_pass_dom";
        public const string Port = "Port";
        public const string SuperUsers = "su";
        public const string Domains = "domains";
        public const string AppSettingsXPath = "//appSettings/*";
        public const string UserPrincipalNameXPath = "//userPrincipalName";

        public static readonly Regex httpAddressRegex = new Regex("(http://)(.[^:]+)(?::([0-9]+))?((/[a-z0-9\\.\\-_]+)+)", RegexOptions.IgnorePatternWhitespace | RegexOptions.IgnoreCase);
        public static readonly Regex httpsAddressRegex = new Regex("(https://)(.[^:]+)(?::([0-9]+))?((/[a-z0-9\\.\\-_]+)+)", RegexOptions.IgnorePatternWhitespace | RegexOptions.IgnoreCase);
        public static readonly Regex userNameDomainRegex = new Regex("", RegexOptions.IgnorePatternWhitespace | RegexOptions.IgnoreCase);
        public static readonly Regex sqlScriptVariableRegEx = new Regex("\\$\\(([a-z0-9\\-_]+)\\)", RegexOptions.IgnorePatternWhitespace | RegexOptions.IgnoreCase);
        public static readonly string[] AttributePaths = new string[] {
            "//@baseAddress",
            "//@address",
            "//@httpGetUrl",
            "//@value",
            "//@targetUri",
            "//value",
            "//@name",
            "//@path"
        };

        public static readonly int SleepTimeMilliseconds = 1000;
    }
}
