﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace BMS.Schedulers
{
    public abstract class BaseCommand : ICommand
    {
        private object ThisLock = new object();

        protected abstract void DoRun(Scheduler scheduler);

        public void Run(Scheduler scheduler)
        {
            if (Monitor.TryEnter(ThisLock))
            {
                try
                {
                    DoRun(scheduler);
                }
                finally
                {
                    Monitor.Exit(ThisLock);
                }
            }
        }
    }
}
