﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Core;
using Mdws2ORM.SessionFactory.Concrete;

namespace Mdws2ORM.SessionFactory
{
    public enum QueryMethods { RunRpc, DDR }

    public class SessionFactoryProvider
    {
        public static readonly SessionFactoryProvider Instance = new SessionFactoryProvider();

        private SessionFactoryProvider() { }
        private QueryMethods? queryMethods;

        public void SetQueryMethods(QueryMethods queryMethods)
        {
            if (this.queryMethods.HasValue)
                throw new InvalidOperationException("Already set query methods");

            this.queryMethods = queryMethods;
        }

        public ISessionFactory MakeSessionFactory()
        {
            if (!queryMethods.HasValue)
                throw new InvalidOperationException("Query methods not set");

            switch (queryMethods.Value)
            {
                case QueryMethods.DDR:
                    ListParamBuilder.DefaultFlags = "IQP";
                    GetParamBuilder.DefaultFlags = "I";
                    return new DdrSessionFactory();
                case QueryMethods.RunRpc:
                    ListParamBuilder.DefaultFlags = "IQ";
                    GetParamBuilder.DefaultFlags = "NI";
                    return new RunRpcSessionFactory();
                default:
                    throw new InvalidOperationException();
            }
        }
    }
}
