﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.BaseFields;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.Fields
{
    public class VariablePointerFieldMap<T> : BaseFieldMap<T> where T : class
    {
        public abstract class BaseItem
        {
            public bool IsFetchEnabled { get; set; }
            public abstract string Location { get; }
            public abstract void Map(IEntityQuery query, T entity, string value);

            public virtual void Init(InitMapMediator initMediator) { }

        }

        public class Item : BaseItem
        {
            private string location;
            private Action<T, string> mapAction;

            public override string Location
            {
                get { return location; }
            }

            public Item(string location, Action<T, string> mapAction)
            {
                this.location = location;
                this.mapAction = mapAction;
            }

            public override void Map(IEntityQuery query, T entity, string value)
            {
                mapAction(entity, value);
            }
        }

        public class ItemFetch<V> : BaseItem where V : class
        {
            private readonly Action<T, string> mapAction;
            private readonly Action<T, V> mapPointerAction;
            private EntityMap<V> entityMap;


            public ItemFetch(Action<T, string> mapAction, Action<T, V> mapPointerAction ,EntityMap<V> entityMap = null)
            {
                this.mapAction = mapAction;
                this.mapPointerAction = mapPointerAction;
                this.entityMap = null;
                IsFetchEnabled = true;
            }

            public override string Location
            {
                get { return entityMap.Location; }
            }

            public override void Map(IEntityQuery query, T entity, string value)
            {
                mapAction(entity, value);
                if (IsFetchEnabled)
                {
                    V referenceEntity = query.GetNotNull(entityMap, GetParamBuilder.DefaultParam, value);
                    mapPointerAction(entity, referenceEntity);
                }
            }

            public override void Init(InitMapMediator initMediator)
            {
                if (entityMap == null) entityMap = initMediator.GetEntityMap<V>();
                entityMap.Initialize(initMediator);
            }
        }


        private BaseItem[] itemsMap;
        private SortedList<string, BaseItem> list;
        private bool isEnabled;
        public IEnumerable<BaseItem> Items { get { return list.Values; } }

        public VariablePointerFieldMap(string field, params BaseItem[] itemsMap)
            : base(field)
        {
            this.itemsMap = itemsMap;
        }

        public bool IsFetchEnabled
        {
            get { return isEnabled; }
            set
            {
                list.Values.ForEach(s => s.IsFetchEnabled = value);
                isEnabled = value;
            }
        }


        public override void Map(IEntityQuery query, T entity, string value)
        {
            int index = value.IndexOf(';');
            if (index == -1) return;
            string val = value.Substring(0, index);
            string location = value.Substring(index + 1);
            BaseItem pointerToFile = list[location];
            pointerToFile.Map(query, entity, val);
        }

        public override void Init(InitMapMediator initMediator)
        {
            list = new SortedList<string, BaseItem>(itemsMap.Length);
            itemsMap.ForEach(s => s.Init(initMediator));
            itemsMap.ForEach(p => list.Add(p.Location, p));
            itemsMap = null;
        }
    }
}
