﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.BaseFields;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.Fields
{
    public class BooleanFieldMap<T> : BaseFieldMap<T> where T : class
    {
        private readonly Action<T, bool> MapAction;

        public BooleanFieldMap(string field, Action<T, bool> mapAction)
            : base(field)
        {
            MapAction = mapAction;
        }

        public override void Map(IEntityQuery query, T entity, string value)
        {
            bool boolean = Converters.ToBool(value);
            MapAction(entity, boolean);
        }
    }
}
