﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.BaseFields
{
    public abstract class BaseFieldMap<T> where T : class
    {
        protected BaseFieldMap(string field)
        {
            Field = field;
        }

        public virtual bool FetchGetOnly
        {
            get
            {
                return false;
            }
        }

        public string Field { get; private set; }
        public abstract void Map(IEntityQuery query, T entity, string value);

        public virtual void Init(InitMapMediator initMediator) { }

    }
}
