﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using Mdws2ORM.Core;

namespace Mdws2ORM
{
    public interface ISession
    {
        IEnumerable<ListItem<T>> List<T>(ListParam listParam, BaseEntityMap<T> entityMap, string iens = "") where T : class;

        IEnumerable<ListItem<T>> List<T>(ListParam listParam, string iens = "") where T : class;

        T Get<T>(GetParam getParam, string iens) where T : class;

        T Get<T>(GetParam getParam, string iens, BaseEntityMap<T> entityMap) where T : class;

        IEnumerable<T> GetSubEntities<T, P>(ListParam param, P parent, string iens)
            where T : class
            where P : class;

        IEnumerable<T> GetSubEntities<T, P>(ListParam param, P parent, string iens, SubEntityMapWithParent<T, P> subEntityMap)
            where T : class
            where P : class;

        IEnumerable<ListItem<T>> ListAllSubEntities<T, P>(ListParam listParam, ListParam subListParam, string iens = "")
            where T : class
            where P : class;

        IEnumerable<ListItem<T>> ListAllSubEntities<T, P>(ListParam listParam, ListParam subListParam, SubEntityMapWithParent<T, P> subEntityMap, string iens = "")
            where T : class
            where P : class;

        IEnumerable<ListItem<T>> ListAllSubEntities<T, P>(ListParam listParam, ListParam subListParam, SubEntityMapWithParent<T, P> subEntityMap, BaseEntityMap<P> entityMap, string iens = "")
            where T : class
            where P : class;

        void SetCacheForType<T>(bool isEnabled) where T : class;

        void ResetCacheForType<T>() where T : class;

        void ResetCache();

        bool ThrowExceptionWhenReferenceEntityNotFound { get; set; }
    }
}
