﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using Mdws2ORM.QuerySvcService;

namespace Mdws2ORM.Exceptions
{
    [Serializable]
    public class QueryFaultException : MdwsException
    {
        public FaultTO Fault { get; private set; }

        public QueryFaultException(FaultTO fault)
            : base("Mdws return a fault. Fault msj: " + fault.message)
        {
            Fault = fault;
        }



        private static void Append(StringBuilder sb, string field, string value)
        {
            if (field == null) return;
            sb.Append("  ");
            sb.Append(field);
            sb.Append(": ");
            sb.Append(value);
            sb.AppendLine();
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder("\nFault details:\n");
            Append(sb, "Message", Fault.message);
            Append(sb, "Type", Fault.type);
            Append(sb, "StackTrace", Fault.stackTrace);
            Append(sb, "InnerMessage", Fault.innerMessage);
            Append(sb, "InnerType", Fault.innerType);
            Append(sb, "InnerStackTrace", Fault.innerStackTrace);

            return base.ToString() + sb.ToString();

        }

        protected QueryFaultException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
            Fault = info.GetValue("Fault", typeof(FaultTO)) as FaultTO;
        }

        public override void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (info == null)
                throw new ArgumentNullException("info");

            info.AddValue("Fault", this.Fault);
            base.GetObjectData(info, context);
        }


    }
}
