﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using System.Configuration;
using BMS.VistaIntegration.Data;
using BMS.Utils;

namespace Mdws2ORM.DdrQueries.Commands
{
    public class Utils
    {
        public static bool IsAlive(QuerySvcSoap _client, VistASite _vistaSite)
        {
            try
            {
                //Tracer.TraceMessage(_vistaSite.Name + " - Utils.IsAlive");
                _client.disconnect();
                var connectDto = VisitSite(_client, _vistaSite);
                if (connectDto.fault == null) return true;
                return connectDto.fault.message.Contains("already connected");
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage(_vistaSite.Name + " - Utils.IsAlive exception");
                Tracer.TraceException(ex);
                return false;
            }
        }

        private static UserTO VisitSite(QuerySvcSoap _client, VistASite _vistaSite)
        {
            try
            {
                string userPwd = ConfigurationManager.AppSettings["visitorAppPwd"];
                string userSiteCode = ConfigurationManager.AppSettings["visitorUserSiteCode"];
                string userName = ConfigurationManager.AppSettings["visitorUserName"];
                string userDuz = ConfigurationManager.AppSettings["visitorUserDuz"];
                string userSsn = ConfigurationManager.AppSettings["visitorUserSsn"];
                string userContext = ConfigurationManager.AppSettings["visitorContext"];         
            
                var visit = _client.visitSite(userPwd, _vistaSite.Number, userSiteCode, userName, userDuz, userSsn, userContext);
                if (TryAgain(visit.fault)) visit = TryConnect(_client, userPwd, _vistaSite.Number, userSiteCode, userName, userDuz, userSsn, userContext, 1);
                if (TryAgain(visit.fault)) visit = TryConnect(_client, userPwd, _vistaSite.Number, userSiteCode, userName, userDuz, userSsn, userContext, 5);
                if (TryAgain(visit.fault)) visit = TryConnect(_client, userPwd, _vistaSite.Number, userSiteCode, userName, userDuz, userSsn, userContext, 10);
                return visit;
            }
            catch { throw new Exception("Default config parameters are incorrect!"); } 
        }

        private static bool TryAgain(FaultTO fault)
        {
            if (fault == null)
                return false;
            else if (fault.message.Equals("The remote procedure XUS INTRO MSG is not registered to the option XUS SIGNON."))
                return true;
            else if (fault.message.Equals("Object synchronization method was called from an unsynchronized block of code."))
                return true;
            return false;
        }

        private static UserTO TryConnect(QuerySvcSoap _client, string userPwd, string number, string userSiteCode, string userName, string userDuz, string userSsn, string userContext, int seconds)
        {
            System.Threading.Thread.Sleep(TimeSpan.FromSeconds(seconds));
            return _client.visitSite(userPwd, number, userSiteCode, userName, userDuz, userSsn, userContext);
        }
    }
}
