r"""Class to Connect to a VistA EHR automatically."""
#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------
import sys
import os
import telnetlib
import TestHelper
import time
import re
import logging

try:
  import pexpect
  no_pexpect = None
except ImportError, no_pexpect:
  pass

#---------------------------------------------------------------------------
#Initial Global Variables to use over the course of connecting

#connection=False
#log =False

#---------------------------------------------------------------------------


class PROMPT(object):
  """Wait for a VISTA> prompt in current namespace."""

class ConnectMUMPS(object):

  def ZN(self, namespace):
    self.wait('>')
    self.write('ZN "' + namespace + '"')
    self.namespace = namespace

  def login(self, username, password):
    self.wait('Username:')
    self.write(username)
    self.wait('Password')
    self.write(password)

  def getenv(self, volume):
    self.write('D GETENV^%ZOSV W Y')
    if sys.platform == 'win32':
      match = self.connection.expect([volume + ':[0-9A-Za-z-]+'], None)
      test = match[1].span()
      VistAboxvol = ''
      for i in range(test[0], test[1]):
        VistAboxvol = VistAboxvol + match[2][i]
      self.boxvol = VistAboxvol
    else:
      self.connection.expect([volume + ':[0-9A-Za-z-]+'], None)
      print self.connection.after
      self.boxvol = self.connection.after

class ConnectWinCache(ConnectMUMPS):
  def __init__(self, logfile, instance, namespace, location='127.0.0.1'):
    #global connection,log
    super(ConnectMUMPS, self).__init__()
    self.connection = telnetlib.Telnet(location, 23)
    if len(namespace) == 0:
      namespace = 'VISTA'
    self.namespace = namespace
    self.log = file(logfile, 'w')
    self.type = 'cache'

  def write(self, command):
    self.connection.write(command + '\r')
    logging.debug('connection.write:' + command)

  def wait(self, command, tout=None):
    if tout is None:
        tout = 15
    if command is PROMPT:
      command = self.namespace + '>'
    rbuf = self.connection.read_until(command, tout)
    if rbuf.find(command) == -1:
        self.log.write('ERROR: expected: ' + command + 'actual: ' + rbuf)
        logging.debug('ERROR: expected: ' + command + 'actual: ' + rbuf)
        raise TestHelper.TestError('ERROR: expected: ' + command + 'actual: ' + rbuf)
    else:
        self.log.write(rbuf)
        logging.debug(rbuf)
        return 1

  def multiwait(self, options, tout=None):
    if tout is None:
      tout = 15
    if isinstance(options, list):
      index = self.connection.expect(options)
      if index == -1:
        logging.debug('ERROR: expected: ' + options)
        raise TestHelper.TestError('ERROR: expected: ' + options)
      self.log.write(index[2])
      return index[0]
    else:
      raise IndexError('Input to multiwait function is not a list')

class ConnectLinuxCache(ConnectMUMPS):
  def __init__(self, logfile, instance, namespace, location='127.0.0.1'):
    super(ConnectMUMPS, self).__init__()
    self.connection = pexpect.spawn('ccontrol session ' + instance + ' -U ' + namespace, timeout=None)
    if len(namespace) == 0:
      namespace = 'VISTA'
    self.namespace = namespace
    self.connection.logfile_read = file(logfile, 'w')
    self.type = 'cache'

  def write(self, command):
    self.connection.send(command + '\r')

  def wait(self, command, tout=None):
    if tout is None:
      tout = 15
    if command is PROMPT:
      command = self.namespace + '>'
    rbuf = self.connection.expect(command, tout)
    if rbuf == -1:
        logging.debug('ERROR: expected: ' + command)
        raise TestHelper.TestError('ERROR: expected: ' + command)
    else:
        return 1

class ConnectLinuxGTM(ConnectMUMPS):
  def __init__(self, logfile, instance, namespace, location='127.0.0.1'):
    super(ConnectMUMPS, self).__init__()
    self.connection = pexpect.spawn('gtm', timeout=None)
    if len(namespace) == 0:
      namespace = 'GTM'
    self.connection.logfile_read = file(logfile, 'w')
    self.namespace = namespace
    self.type = 'GTM'

  def write(self, command):
    self.connection.send(command + '\r')
    logging.debug('WRITE: ' + command)

  def wait(self, command, tout=None):
    if tout is None:
      tout = 120
    if command is PROMPT:
      command = self.namespace + '>'
    rbuf = self.connection.expect(command, tout)
    logging.debug('RECEIVED: ' + command)
    if rbuf == -1:
        logging.debug('ERROR: expected: ' + command)
        raise TestHelper.TestError('ERROR: expected: ' + command)
    else:
        return 1

  def multiwait(self, options, tout=None):
    if tout is None:
      tout = 15
    if isinstance(options, list):
      index = self.connection.expect(options, timeout=tout)
      if index == -1:
        logging.debug('ERROR: expected: ' + options)
        raise TestHelper.TestError('ERROR: expected: ' + options)
      return index
    else:
      raise IndexError('Input to multiwait function is not a list')



def ConnectToMUMPS(logfile, instance='CACHE', namespace='VISTA', location='127.0.0.1'):

    global connection
    #self.namespace = namespace
    #self.location = location
    #print "You are using " + sys.platform
    if sys.platform == 'win32':
      return ConnectWinCache(logfile, instance, namespace, location)
    elif sys.platform == 'linux2':
      if no_pexpect:
        raise no_pexpect
      try:
        return ConnectLinuxCache(logfile, instance, namespace, location)
      except pexpect.ExceptionPexpect, no_cache:
        pass
      try:
        return ConnectLinuxGTM(logfile, instance, namespace, location)
      except pexpect.ExceptionPexpect, no_gtm:
         if (no_cache and no_gtm):
           raise "Cannot find a MUMPS instance"
