-- Columns

CREATE TABLE [dbo].[CPRS_ORDERS]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[OBJECT_OF_ORDER] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE_OF_LAST_ACTIVITY] [datetime] NULL,
[ORDER_STATUS_ID] [int] NOT NULL,
[PATIENT_LOCATION_ID] [int] NULL,
[ITEM_ORDERED] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[START_DATE] [datetime] NULL,
[STOP_DATE] [datetime] NULL,
[DC_DATE_TIME] [datetime] NULL,
[TO_DISPLAY_GROUP_ID] [int] NULL,
[ORDERABLE_ITEM_ID] [int] NULL,
[INTERNAL_UID] [uniqueidentifier] NULL,
)
GO
-- Triggers


-- The trigger inserts in CPRS_ORDERS_LOG the rows updated in CPRS_ORDERS table.
CREATE TRIGGER [dbo].[CPRS_ORDERS_tgg_update]
   ON  [dbo].[CPRS_ORDERS]
   AFTER update
AS 
BEGIN	

	INSERT INTO [dbo].[WORKFLOW_LOG] ( CPRS_ORDERS_ID )

        SELECT IEN
          FROM inserted;
END
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[CPRS_ORDERS] ADD CONSTRAINT [PK_CPRSE_ORDERS] PRIMARY KEY CLUSTERED  ([IEN])
GO
-- Foreign Keys

ALTER TABLE [dbo].[CPRS_ORDERS] ADD CONSTRAINT [FK_CPRS_ORDERS_ORDER_STATUS] FOREIGN KEY ([ORDER_STATUS_ID]) REFERENCES [dbo].[ORDER_STATUS] ([IEN])
GO
ALTER TABLE [dbo].[CPRS_ORDERS] ADD CONSTRAINT [FK_CPRS_ORDERS_ORDERABLE_ITEM] FOREIGN KEY ([ORDERABLE_ITEM_ID]) REFERENCES [dbo].[ORDERABLE_ITEM] ([IEN])
GO
ALTER TABLE [dbo].[CPRS_ORDERS] ADD CONSTRAINT [FK_CPRS_ORDERS_HOSPITAL_LOCATION] FOREIGN KEY ([PATIENT_LOCATION_ID]) REFERENCES [dbo].[HOSPITAL_LOCATION] ([IEN])
GO
ALTER TABLE [dbo].[CPRS_ORDERS] ADD CONSTRAINT [FK_CPRS_ORDERS_CPRS_ORDERS] FOREIGN KEY ([TO_DISPLAY_GROUP_ID]) REFERENCES [dbo].[DISPLAY_GROUP] ([IEN])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'The orders table from the CPRS Vista module.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time of the last activity.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'DATE_OF_LAST_ACTIVITY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the table.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The order''s item.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'ITEM_ORDERED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The object of the order.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'OBJECT_OF_ORDER'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The foreign key of the order status table.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'ORDER_STATUS_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the orderable item.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'ORDERABLE_ITEM_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the patient location.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'PATIENT_LOCATION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time the order started.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'START_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time the order must finish.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'STOP_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the display group.', 'SCHEMA', N'dbo', 'TABLE', N'CPRS_ORDERS', 'COLUMN', N'TO_DISPLAY_GROUP_ID'
GO