IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Rpt_VisnWaitingList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Rpt_VisnWaitingList]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_Rpt_VisnWaitingList]
	@DATE_FROM DATETIME,
	@DATE_TO DATETIME,
	@TIME_ZONE_MINUTES_OFFSET INT,
	@UserID NVARCHAR(500),
	@FACILITIES_IDS NVARCHAR(MAX) = '',
	@REPORT_TYPE NVARCHAR(50)
AS
BEGIN

	SET NOCOUNT ON;
	
	
	IF (@REPORT_TYPE = 'VISN_WAIT_LIST')
	BEGIN
		
		IF @DATE_FROM > @DATE_TO
			RAISERROR ('The start date is greater than the end date. Please correct.', 18, 13)
		ELSE
		BEGIN
		
			set @DATE_FROM = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @DATE_FROM );
			set @DATE_TO = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @DATE_TO );

			--GET INFORMATION ABOUT SELECTED FACILITIES
			CREATE TABLE #TBL_FACILITY (SOURCE_ID NVARCHAR(250) PRIMARY KEY, FACILITY_NAME NVARCHAR(250), TIMEZONE_OFFSET INT)
			INSERT INTO #TBL_FACILITY(SOURCE_ID, FACILITY_NAME, TIMEZONE_OFFSET) 
			SELECT DISTINCT CONVERT(NVARCHAR(250), FACILITY.VALUE), ORG.NAME,  [dbo].[ufn_GetOffsetByFacilityUID](VALUE) 
			FROM dbo.ufn_Split(@FACILITIES_IDS, ',') AS FACILITY
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS ENTITY ON ENTITY.IDENTIFIER = FACILITY.VALUE 
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS ORG ON ORG.PFK_ORGANIZATION = ENTITY.PK_ENTITY
			
			
			--GET VOCABULARY ERA			
			CREATE TABLE #ERA(PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NVARCHAR(250))
			INSERT INTO #ERA(PK, SOURCE_ID, DISPLAY_NAME)
			SELECT MAX_WAITING_AREA.PK, MAX_WAITING_AREA.ID, CONCEPT.DISPLAY_NAME
			FROM (	
			SELECT MAX(PK) AS PK, ID
			FROM dbo.CONCEPT_H
			WHERE code_system_name = 'Era'
			GROUP BY ID) AS MAX_WAITING_AREA 
			INNER JOIN DBO.CONCEPT_H AS CONCEPT ON CONCEPT.PK = MAX_WAITING_AREA.PK
						
			--GET VOCABULARY STRICT DECISION
			CREATE TABLE #STRICT_DECISION (PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NVARCHAR(250))
			INSERT INTO #STRICT_DECISION(PK, SOURCE_ID, DISPLAY_NAME)				
			SELECT MAX_CONCEPT_CONTRACT._PK, MAX_CONCEPT_CONTRACT.ID, CONCEPT_C.DISPLAY_NAME
			FROM(
					SELECT MAX(PK) as _PK, ID
					FROM dbo.CONCEPT_H
					WHERE code_system_name = 'StrictDecision'
					GROUP BY ID ) AS MAX_CONCEPT_CONTRACT 
			INNER JOIN dbo.CONCEPT_H AS CONCEPT_C ON CONCEPT_C.PK = MAX_CONCEPT_CONTRACT._PK
				
			--GET VOCABULARY VISTA SPECIALTY
			CREATE TABLE #VISTA_SPECIALTY(PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NVARCHAR(250))
			INSERT INTO #VISTA_SPECIALTY(PK, SOURCE_ID, DISPLAY_NAME)	
			SELECT MAX_CONCEPT_SERVICE._PK, MAX_CONCEPT_SERVICE.ID, CONCEPT_S.DISPLAY_NAME	
			FROM(
					SELECT MAX(PK) as _PK, ID
					FROM dbo.CONCEPT_H
					WHERE code_system_name = 'VistaSpecialty'
					GROUP BY ID
					
				) AS MAX_CONCEPT_SERVICE 
			INNER JOIN dbo.CONCEPT_H AS CONCEPT_S ON CONCEPT_S.PK = MAX_CONCEPT_SERVICE._PK				
			
			CREATE TABLE #HISTORY_VISN_WAITING_LIST
			(
			[PK] [int] NOT NULL PRIMARY KEY,
			[ACT_ID] [int] NOT NULL,
			[FACILITY_NAME] [NVARCHAR] (250) NULL,
			[PATIENT_UID] [UNIQUEIDENTIFIER] NULL,
			[FACILITY_VISN] [NVARCHAR] (100) NULL,
			[ERA] [NVARCHAR] (250) NULL,
			[CONTRACT] [NVARCHAR] (250) NULL,
			[DIAGNOSIS] [NVARCHAR] (250) NULL,
			[CURRENT_LOCATION] [NVARCHAR] (250) NULL,
			[LOC_ADM_DATE] [DATETIME] NULL,
			[COMMENTS] [NVARCHAR] (250)  NULL,
			[SPECIALTY] [NVARCHAR] (250) NULL,
			[REQ_DATE] [DATETIME] NULL,
			[CREATED_BY] [nvarchar] (50) NULL,
			[DATE_FAC] [DATETIME] NULL,
			TRANSACTION_TYPE_CODE [varchar] (50) NULL
			)
			CREATE UNIQUE INDEX IX_HISTORY_W_L_PK_ACT_ID ON #HISTORY_VISN_WAITING_LIST(PK, ACT_ID)
			CREATE UNIQUE NONCLUSTERED INDEX IX_HISTORY_W_L_FAC_NAME_ACT_ID_DATE_FAC ON #HISTORY_VISN_WAITING_LIST (FACILITY_NAME, ACT_ID, DATE_FAC) 
			
			INSERT INTO #HISTORY_VISN_WAITING_LIST(PK, ACT_ID, FACILITY_NAME, PATIENT_UID, FACILITY_VISN,
												   ERA,[CONTRACT],DIAGNOSIS,CURRENT_LOCATION,LOC_ADM_DATE,
												   COMMENTS, SPECIALTY, REQ_DATE, CREATED_BY, DATE_FAC,	TRANSACTION_TYPE_CODE)
			SELECT FIRST_ROW_COMPARED.PK, FIRST_ROW_COMPARED.ACT_ID, FAC.FACILITY_NAME,
					A.PATIENT_UID,
					FIRST_ROW_COMPARED.FACILITY_VISN, CONCEPT_ERA.DISPLAY_NAME, CONCEPT_C.DISPLAY_NAME, FIRST_ROW_COMPARED.DIAGNOSIS, 
					FIRST_ROW_COMPARED.CURRENT_LOCATION, 
					DATEADD (minute, 
					ISNULL(FAC.TIMEZONE_OFFSET * 60,
							@TIME_ZONE_MINUTES_OFFSET), FIRST_ROW_COMPARED.LOCATION_ADMISSION_DATE),
					FIRST_ROW_COMPARED.COMMENTS, CONCEPT_S.DISPLAY_NAME,
					DATEADD (minute, 
					ISNULL(FAC.TIMEZONE_OFFSET * 60,
							@TIME_ZONE_MINUTES_OFFSET), FIRST_ROW_COMPARED.REQUESTED_DATE),
					case when FIRST_ROW_COMPARED.CREATED_BY is null then 'System' 
						 else (FIRST_ROW_COMPARED.LAST_EDIT_BY)
					end,
					DATEADD (minute, 
					ISNULL(FAC.TIMEZONE_OFFSET * 60,
							@TIME_ZONE_MINUTES_OFFSET), FIRST_ROW_COMPARED.[DATE]),
					FIRST_ROW_COMPARED.TRANSACTION_TYPE_CODE 
			FROM TRANSFER_REQ_H AS FIRST_ROW_COMPARED
				 INNER JOIN #TBL_FACILITY AS FAC ON FAC.SOURCE_ID = FIRST_ROW_COMPARED.FACILITY_UID 
				 LEFT JOIN #ERA AS CONCEPT_ERA ON CONCEPT_ERA.SOURCE_ID = FIRST_ROW_COMPARED.ERA_ID
				 LEFT JOIN #STRICT_DECISION AS CONCEPT_C ON CONCEPT_C.SOURCE_ID = FIRST_ROW_COMPARED.CONTRACT_ID
				 LEFT JOIN #VISTA_SPECIALTY AS CONCEPT_S ON CONCEPT_S.SOURCE_ID = FIRST_ROW_COMPARED.SPECIALITY_ID	
				 INNER JOIN (SELECT distinct ID, PATIENT_UID FROM dbo.ACT_H) A ON FIRST_ROW_COMPARED.ACT_ID = A.ID	
				 LEFT JOIN TRANSFER_REQ_H AS SECOND_ROW_COMPARED ON  SECOND_ROW_COMPARED.PK = (SELECT MAX(NEXT_ROW_COMPARED.PK)
    				FROM TRANSFER_REQ_H AS NEXT_ROW_COMPARED 				
    				WHERE NEXT_ROW_COMPARED.ACT_ID = FIRST_ROW_COMPARED.ACT_ID AND  
    				NEXT_ROW_COMPARED.PK < FIRST_ROW_COMPARED.PK AND
    				(NEXT_ROW_COMPARED.[DATE] >= @DATE_FROM and NEXT_ROW_COMPARED.[DATE] <= @DATE_TO))       
					AND (FIRST_ROW_COMPARED.FACILITY_UID = SECOND_ROW_COMPARED.FACILITY_UID OR (FIRST_ROW_COMPARED.FACILITY_UID IS NULL AND SECOND_ROW_COMPARED.FACILITY_UID IS NULL))
					AND (FIRST_ROW_COMPARED.FACILITY_VISN = SECOND_ROW_COMPARED.FACILITY_VISN OR (FIRST_ROW_COMPARED.FACILITY_VISN IS NULL AND SECOND_ROW_COMPARED.FACILITY_VISN IS NULL))	
					AND (FIRST_ROW_COMPARED.ERA_ID = SECOND_ROW_COMPARED.ERA_ID OR (FIRST_ROW_COMPARED.ERA_ID IS NULL AND SECOND_ROW_COMPARED.ERA_ID IS NULL))	
					AND (FIRST_ROW_COMPARED.CONTRACT_ID = SECOND_ROW_COMPARED.CONTRACT_ID OR (FIRST_ROW_COMPARED.CONTRACT_ID IS NULL AND SECOND_ROW_COMPARED.CONTRACT_ID IS NULL))
					AND (FIRST_ROW_COMPARED.DIAGNOSIS = SECOND_ROW_COMPARED.DIAGNOSIS OR (FIRST_ROW_COMPARED.DIAGNOSIS IS NULL AND SECOND_ROW_COMPARED.DIAGNOSIS IS NULL))		
					AND (FIRST_ROW_COMPARED.CURRENT_LOCATION = SECOND_ROW_COMPARED.CURRENT_LOCATION OR (FIRST_ROW_COMPARED.CURRENT_LOCATION IS NULL AND SECOND_ROW_COMPARED.CURRENT_LOCATION IS NULL))
					AND (FIRST_ROW_COMPARED.LOCATION_ADMISSION_DATE = SECOND_ROW_COMPARED.LOCATION_ADMISSION_DATE OR (FIRST_ROW_COMPARED.LOCATION_ADMISSION_DATE IS NULL AND SECOND_ROW_COMPARED.LOCATION_ADMISSION_DATE IS NULL))	  	
					AND (FIRST_ROW_COMPARED.COMMENTS = SECOND_ROW_COMPARED.COMMENTS OR (FIRST_ROW_COMPARED.COMMENTS IS NULL AND SECOND_ROW_COMPARED.COMMENTS IS NULL))	  
					AND (FIRST_ROW_COMPARED.SPECIALITY_ID = SECOND_ROW_COMPARED.SPECIALITY_ID OR (FIRST_ROW_COMPARED.SPECIALITY_ID IS NULL AND SECOND_ROW_COMPARED.SPECIALITY_ID IS NULL))	  
					AND (FIRST_ROW_COMPARED.REQUESTED_DATE = SECOND_ROW_COMPARED.REQUESTED_DATE OR (FIRST_ROW_COMPARED.REQUESTED_DATE IS NULL AND SECOND_ROW_COMPARED.REQUESTED_DATE IS NULL))	  	
			WHERE SECOND_ROW_COMPARED.PK IS NULL AND FIRST_ROW_COMPARED.[DATE] >= @DATE_FROM AND FIRST_ROW_COMPARED.[DATE] <= @DATE_TO
			ORDER BY FIRST_ROW_COMPARED.ACT_ID, FIRST_ROW_COMPARED.PK DESC
			
			DROP TABLE #TBL_FACILITY
			DROP TABLE #ERA
			DROP TABLE #STRICT_DECISION
			DROP TABLE #VISTA_SPECIALTY
			
			
			CREATE TABLE #PATIENTS (PATIENT_UID UNIQUEIDENTIFIER PRIMARY KEY, PATIENT_NAME NVARCHAR(250))
			INSERT INTO #PATIENTS(PATIENT_UID, PATIENT_NAME)
			SELECT DISTINCT PAC.PATIENT_UID, SUBSTRING(PERSON.[NAME_FAMILY], 1, 1) + SUBSTRING(s.[IDENTIFIER_EXTENSION], 7, 5)
			FROM #HISTORY_VISN_WAITING_LIST AS PAC
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS ENTITY ON ENTITY.IDENTIFIER = PAC.PATIENT_UID
			INNER JOIN $(varBMS_EIS).dbo.EHL7_PERSON AS PERSON ON PERSON.PFK_PERSON = ENTITY.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS S ON S.FK_ENTITY = PERSON.PFK_PERSON AND S.IDENTIFIER_ROOT = 'SSN'
			
			SELECT H_VISN_WAITING_LIST.ACT_ID,
			CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					 CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
						ELSE H_VISN_WAITING_LIST.FACILITY_NAME		
					 END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.FACILITY_NAME
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.FACILITY_NAME = H_VISN_WAITING_LIST.FACILITY_NAME THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.FACILITY_NAME IS NOT NULL AND H_VISN_WAITING_LIST.FACILITY_NAME IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE H_VISN_WAITING_LIST.FACILITY_NAME		
					END 
			 END AS FACILITY,	 
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE PATIENT.PATIENT_NAME		
					END 
				 WHEN 'I' THEN 	PATIENT.PATIENT_NAME
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.PATIENT_UID = H_VISN_WAITING_LIST.PATIENT_UID THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.PATIENT_UID IS NOT NULL AND H_VISN_WAITING_LIST.PATIENT_UID IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE PATIENT.PATIENT_NAME		
					END 
			 END AS PATIENT_NAME,
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_VISN_WAITING_LIST.FACILITY_VISN
					END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.FACILITY_VISN
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.FACILITY_VISN = H_VISN_WAITING_LIST.FACILITY_VISN THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.FACILITY_VISN IS NOT NULL AND H_VISN_WAITING_LIST.FACILITY_VISN IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_VISN_WAITING_LIST.FACILITY_VISN		
					END 
			 END AS VISN,
			 
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_VISN_WAITING_LIST.ERA
					END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.ERA
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.ERA = H_VISN_WAITING_LIST.ERA THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.ERA IS NOT NULL AND H_VISN_WAITING_LIST.ERA IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_VISN_WAITING_LIST.ERA		
					END 
			 END AS ERA,	 
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_VISN_WAITING_LIST.[CONTRACT]
					END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.[CONTRACT]
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.[CONTRACT] = H_VISN_WAITING_LIST.[CONTRACT] THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.[CONTRACT] IS NOT NULL AND H_VISN_WAITING_LIST.[CONTRACT] IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_VISN_WAITING_LIST.[CONTRACT]		
					END 
			 END AS [CONTRACT], 		 
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_VISN_WAITING_LIST.DIAGNOSIS
					END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.DIAGNOSIS
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.DIAGNOSIS = H_VISN_WAITING_LIST.DIAGNOSIS THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.DIAGNOSIS IS NOT NULL AND H_VISN_WAITING_LIST.DIAGNOSIS IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_VISN_WAITING_LIST.DIAGNOSIS		
					END 
			 END AS DIAGNOSIS,	 
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_VISN_WAITING_LIST.CURRENT_LOCATION
					END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.CURRENT_LOCATION
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.CURRENT_LOCATION = H_VISN_WAITING_LIST.CURRENT_LOCATION THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.CURRENT_LOCATION IS NOT NULL AND H_VISN_WAITING_LIST.CURRENT_LOCATION IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_VISN_WAITING_LIST.CURRENT_LOCATION		
					END 
			 END AS CURRENT_LOCATION,  
			CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE convert(varchar(20),H_VISN_WAITING_LIST.LOC_ADM_DATE,101)+ ' '+convert(varchar(20),H_VISN_WAITING_LIST.LOC_ADM_DATE,108)+ ' ' +right(convert(varchar(30),H_VISN_WAITING_LIST.LOC_ADM_DATE,109),2) 
					END 
				 WHEN 'I' THEN convert(varchar(20),H_VISN_WAITING_LIST.LOC_ADM_DATE,101)+ ' '+convert(varchar(20),H_VISN_WAITING_LIST.LOC_ADM_DATE,108)+ ' ' +right(convert(varchar(30),H_VISN_WAITING_LIST.LOC_ADM_DATE,109),2) 
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.LOC_ADM_DATE = H_VISN_WAITING_LIST.LOC_ADM_DATE THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.LOC_ADM_DATE IS NOT NULL AND H_VISN_WAITING_LIST.LOC_ADM_DATE IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE   convert(varchar(20),H_VISN_WAITING_LIST.LOC_ADM_DATE,101)+ ' '+convert(varchar(20),H_VISN_WAITING_LIST.LOC_ADM_DATE,108)+ ' ' +right(convert(varchar(30),H_VISN_WAITING_LIST.LOC_ADM_DATE,109),2) 		
					END 
			 END AS LOC_ADM_DATE,
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_VISN_WAITING_LIST.COMMENTS
					END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.COMMENTS
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.COMMENTS = H_VISN_WAITING_LIST.COMMENTS THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.COMMENTS IS NOT NULL AND H_VISN_WAITING_LIST.COMMENTS IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_VISN_WAITING_LIST.COMMENTS		
					END 
			 END AS COMMENTS,
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_VISN_WAITING_LIST.SPECIALTY
					END 
				 WHEN 'I' THEN 	H_VISN_WAITING_LIST.SPECIALTY
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.SPECIALTY = H_VISN_WAITING_LIST.SPECIALTY THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.SPECIALTY IS NOT NULL AND H_VISN_WAITING_LIST.SPECIALTY IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_VISN_WAITING_LIST.SPECIALTY		
					END 
			 END AS SPECIALTY, 
			 CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE convert(varchar(20),H_VISN_WAITING_LIST.REQ_DATE,101)+ ' '+convert(varchar(20),H_VISN_WAITING_LIST.REQ_DATE,108)+ ' ' +right(convert(varchar(30),H_VISN_WAITING_LIST.REQ_DATE,109),2) 
					END 
				 WHEN 'I' THEN convert(varchar(20),H_VISN_WAITING_LIST.REQ_DATE,101)+ ' '+convert(varchar(20),H_VISN_WAITING_LIST.REQ_DATE,108)+ ' ' +right(convert(varchar(30),H_VISN_WAITING_LIST.REQ_DATE,109),2) 
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.REQ_DATE = H_VISN_WAITING_LIST.REQ_DATE THEN ''
						 WHEN PREVIOUS_H_VISN_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_VISN_WAITING_LIST.REQ_DATE IS NOT NULL AND H_VISN_WAITING_LIST.REQ_DATE IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE   convert(varchar(20),H_VISN_WAITING_LIST.REQ_DATE,101)+ ' '+convert(varchar(20),H_VISN_WAITING_LIST.REQ_DATE,108)+ ' ' +right(convert(varchar(30),H_VISN_WAITING_LIST.REQ_DATE,109),2) 		
					END 
			 END AS REQ_DATE,
			 CASE WHEN H_VISN_WAITING_LIST.CREATED_BY IS NULL THEN 'SYSTEM' 
						 ELSE  H_VISN_WAITING_LIST.CREATED_BY
					END AS CREATED_BY,
			 H_VISN_WAITING_LIST.DATE_FAC AS DATE_FAC,
			CASE H_VISN_WAITING_LIST.TRANSACTION_TYPE_CODE WHEN 'I' THEN 'Inserted'
					WHEN 'U' THEN 'Updated' WHEN 'D' THEN 'Deleted' END AS EVENT_TYPE
		FROM #HISTORY_VISN_WAITING_LIST AS H_VISN_WAITING_LIST
		LEFT JOIN #HISTORY_VISN_WAITING_LIST AS PREVIOUS_H_VISN_WAITING_LIST ON PREVIOUS_H_VISN_WAITING_LIST.PK = (SELECT MAX(PK) FROM #HISTORY_VISN_WAITING_LIST WHERE ACT_ID = H_VISN_WAITING_LIST.ACT_ID AND PK < H_VISN_WAITING_LIST.PK)
		LEFT JOIN #PATIENTS AS PATIENT ON PATIENT.PATIENT_UID = H_VISN_WAITING_LIST.PATIENT_UID
		ORDER BY  H_VISN_WAITING_LIST.FACILITY_NAME, H_VISN_WAITING_LIST.ACT_ID,  H_VISN_WAITING_LIST.DATE_FAC 
 
		DROP TABLE #HISTORY_VISN_WAITING_LIST
		DROP TABLE #PATIENTS
	END
		
	END
	
END

GO