CREATE TABLE [dbo].[RESOURCE_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [uniqueidentifier] NOT NULL,
[ROOT] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EXTENSION] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[RESOURCE_H] ADD CONSTRAINT [PK_RESOURCE_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains resources,', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Resource''s extension.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', 'COLUMN', N'EXTENSION'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Resource id.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The root of the resource.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', 'COLUMN', N'ROOT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
