IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ETL_Incremental_UpdateDimIconFlag]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ETL_Incremental_UpdateDimIconFlag]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_ETL_Incremental_UpdateDimIconFlag]
@END_DATE DATETIME, @SOURCE_DB NVARCHAR(250)
AS
BEGIN
SET NOCOUNT ON;

BEGIN TRY

	DECLARE @SQL VARCHAR(max), @FROM_CLAUSE NVARCHAR(MAX), @INDEX INT, @ROWS INT, @START_DATE DATETIME
	
	--TRUNCATE TABLE DIM_ICON_FLAG_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_ETL]'))
	BEGIN
		TRUNCATE TABLE DIM_ICON_FLAG_ETL
	END
		
	SELECT @START_DATE = ISNULL(max(_ssis_timestamp), '1900-01-01') FROM DIM_ICON_FLAG
	SET @INDEX = CHARINDEX('.', @SOURCE_DB)		
	
	IF @INDEX = 0
		SET @FROM_CLAUSE = @SOURCE_DB + '.[dbo].[ufn_ETL_Dim_Icon_Flag](''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''', ''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''')'
	ELSE
		SET @FROM_CLAUSE = 'OPENQUERY( ' + SUBSTRING(@SOURCE_DB, 0, @INDEX) + ', ''SELECT * FROM ' + SUBSTRING(@SOURCE_DB, @INDEX + 1, LEN(@SOURCE_DB)) + 
					'.[dbo].[ufn_ETL_Dim_Icon_Flag](''''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''''', ''''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''''') '')'
		
	SET @SQL = ''
	SET @SQL = @SQL + '
		INSERT INTO DIM_ICON_FLAG_ETL ([GROUP], [SUBGROUP], [APP_ICONS_CODE], [IMAGE_BYTES], [IMAGE_BYTES_INACTIVE], [ORDER_INDEX], [ACTIVE], [PUBLISHED]
			  ,[PATIENT_OR_ROOMBED], [IMAGE_NAME], [ICON_NAME], [SHORT_DESCRIPTION], [LONG_DESCRIPTION], [COMMENT], [MOUSE_OVER_TEXT]
			  ,[ENTERED_BY], [ENTERED_DATE], [LAST_EDIT_BY], [LAST_EDIT_DATE], [SOURCE_ID], [_SSIS_TIMESTAMP])
		SELECT [GROUP], [SUBGROUP], [APP_ICONS_CODE], [IMAGE_BYTES], [IMAGE_BYTES_INACTIVE], [ORDER_INDEX], [ACTIVE], [PUBLISHED]
			  ,[PATIENT_OR_ROOMBED], [IMAGE_NAME], [ICON_NAME], [SHORT_DESCRIPTION], [LONG_DESCRIPTION], [COMMENT], [MOUSE_OVER_TEXT]
			  ,[ENTERED_BY], [ENTERED_DATE], [LAST_EDIT_BY], [LAST_EDIT_DATE], [SOURCE_ID], [_SSIS_TIMESTAMP]
		FROM ' + @FROM_CLAUSE
	EXEC (@SQL)
	
	SET @ROWS = @@ROWCOUNT
	
	IF @ROWS <> 0
	BEGIN
		UPDATE tbl
		SET [GROUP] = u.[GROUP]
			,[SUBGROUP] = u.[SUBGROUP]
			,[DIM_APPLICATION_ICONS_ID] = dap.ID
			,[IMAGE_BYTES] = u.[IMAGE_BYTES]
			,[IMAGE_BYTES_INACTIVE] = u.[IMAGE_BYTES_INACTIVE]
			,[ORDER_INDEX] = u.[ORDER_INDEX]
			,[ACTIVE] = u.[ACTIVE]
			,[PUBLISHED] = u.[PUBLISHED]
			,[PATIENT_OR_ROOMBED] = u.[PATIENT_OR_ROOMBED]
			,[IMAGE_NAME] = u.[IMAGE_NAME]
			,[ICON_NAME] = u.[ICON_NAME]
			,[SHORT_DESCRIPTION] = u.[SHORT_DESCRIPTION]
			,[LONG_DESCRIPTION] = u.[LONG_DESCRIPTION]
			,[COMMENT] = u.[COMMENT]
			,[MOUSE_OVER_TEXT] = u.[MOUSE_OVER_TEXT]
			,[ENTERED_BY] = u.[ENTERED_BY]
			,[ENTERED_DATE] = u.[ENTERED_DATE]
			,[LAST_EDIT_BY] = u.[LAST_EDIT_BY]
			,[LAST_EDIT_DATE] = u.[LAST_EDIT_DATE]
			,[SOURCE_ID] = u.[SOURCE_ID]
			,[_SSIS_TIMESTAMP] = u.[_SSIS_TIMESTAMP]
		FROM dbo.DIM_ICON_FLAG tbl
		INNER JOIN DIM_ICON_FLAG_ETL u ON tbl.SOURCE_ID = u.SOURCE_ID
		LEFT JOIN dbo.DIM_APPLICATION_ICONS dap on u.APP_ICONS_CODE = dap.code

		INSERT INTO [DIM_ICON_FLAG]
			([GROUP]
			,[SUBGROUP]
			,[DIM_APPLICATION_ICONS_ID]
			,[IMAGE_BYTES]
			,[IMAGE_BYTES_INACTIVE]
			,[ORDER_INDEX]
			,[ACTIVE]
			,[PUBLISHED]
			,[PATIENT_OR_ROOMBED]
			,[IMAGE_NAME]
			,[ICON_NAME]
			,[SHORT_DESCRIPTION]
			,[LONG_DESCRIPTION]
			,[COMMENT]
			,[MOUSE_OVER_TEXT]
			,[ENTERED_BY]
			,[ENTERED_DATE]
			,[LAST_EDIT_BY]
			,[LAST_EDIT_DATE]
			,[SOURCE_ID]
			,[_SSIS_TIMESTAMP])
		SELECT   [GROUP]
			,[SUBGROUP]
			,dap.ID
			,[IMAGE_BYTES]
			,[IMAGE_BYTES_INACTIVE]
			,[ORDER_INDEX]
			,[ACTIVE]
			,[PUBLISHED]
			,[PATIENT_OR_ROOMBED]
			,[IMAGE_NAME]
			,[ICON_NAME]
			,[SHORT_DESCRIPTION]
			,[LONG_DESCRIPTION]
			,[COMMENT]
			,[MOUSE_OVER_TEXT]
			,[ENTERED_BY]
			,[ENTERED_DATE]
			,[LAST_EDIT_BY]
			,[LAST_EDIT_DATE]
			,difu.[SOURCE_ID]
			,difu.[_SSIS_TIMESTAMP]
		FROM DIM_ICON_FLAG_ETL  difu 
		LEFT JOIN dbo.DIM_APPLICATION_ICONS dap on difu.APP_ICONS_CODE = dap.code
		WHERE NOT EXISTS (SELECT 1 FROM DIM_ICON_FLAG WHERE SOURCE_ID = difu.SOURCE_ID) 
	END
	
	RETURN @ROWS
END TRY
BEGIN CATCH
	
	DECLARE @ErrorMessage NVARCHAR(4000), @ErrorSeverity INT, @ErrorState INT;
			
	SELECT @ErrorMessage = '*** ERROR in usp_ETL_Incremental_UpdateDimIconFlag: ' + ERROR_MESSAGE(),
		   @ErrorSeverity = ERROR_SEVERITY(),
		   @ErrorState = ERROR_STATE();
	
	RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState) WITH LOG;
END CATCH	

END

GO


