CREATE TABLE [dbo].[FACT_SCHEDULED_ADMISSION_ETL](
	[DIM_PATIENT_ID] [nvarchar](250) NULL,
	[IEN] [varchar](50) NULL,
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[CANCELED_DATE] [datetime] NULL,
	[RESERVATION_DATE] [datetime] NULL,
	[PROVIDER_DIM_PHYSICIAN_ID] [nvarchar](250) NULL,
	[SCHEDULER_DIM_PHYSICIAN_ID] [nvarchar](250) NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[DIM_WARD_ID] [nvarchar](250) NULL,
	[DIM_TREATING_SPECIALTY_CODE] [varchar](100) NULL,
	[DIAGNOSIS] [nvarchar](max) NULL,
	[SURGERY] [bit] NULL,
	[LENGTH_OF_STAY_EXPECTED] [int] NULL,
	[MEDICAL_DIVISION_CODE] [varchar](100) NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[SOURCE_ID] [int] NOT NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains temporary scheduled admission information from bms database. Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_SCHEDULED_ADMISSION_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_DIM_PATIENT_ID] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[DIM_PATIENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_TREATING_SPECIALTY_CODE] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[DIM_TREATING_SPECIALTY_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_WARD_ID] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[DIM_WARD_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DOMAIN_ID] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_MEDICAL_DIVISION_CODE] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[MEDICAL_DIVISION_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_PROVIDER_DIM_PHYSICIAN_ID] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[PROVIDER_DIM_PHYSICIAN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SCHEDULER_DIM_PHYSICIAN_ID] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[SCHEDULER_DIM_PHYSICIAN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_ID] ON [dbo].[FACT_SCHEDULED_ADMISSION_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO